﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nn_Macro.h>

#include <nn/gfxTool/gfxTool_DllBase.h>
#include <nn/gfxTool/gfxTool_ShaderUtils.h>

namespace nn {
namespace gfxTool {

class ShaderUtilsDll
    : public DllBase
{
public:
    ShaderUtilsDll()
        : DllBase()
    {
    }

    virtual bool Initialize( const char* pDllPath ) override;

public:
    decltype( &::GSH2GetABIVersion ) Gsh2GetAbiVersion;

    decltype( &::GSH2Initialize ) Gsh2Initialize;
    decltype( &::GSH2Destroy ) Gsh2Destroy;

    decltype( &::GSH2CompileProgram ) Gsh2CompileProgram;
    decltype( &::GSH2CompileProgram2 ) Gsh2CompileProgram2;
    decltype( &::GSH2CompileProgram3 ) Gsh2CompileProgram3;
    decltype( &::GSH2DestroyGX2Program ) Gsh2DestroyGx2Program;
    decltype( &::GSH2DestroyGX2Program3 ) Gsh2DestroyGx2Program3;

    decltype( &::GSH2CalcFetchShaderSizeEx ) Gsh2CalcFetchShaderSizeEx;
    decltype( &::GSH2InitFetchShaderEx ) Gsh2InitFetchShaderEx;

    decltype( &::GSH2GetVertexShaderGPRs ) Gsh2GetVertexShaderGprs;
    decltype( &::GSH2GetGeometryShaderGPRs ) Gsh2GetGeometryShaderGprs;
    decltype( &::GSH2GetPixelShaderGPRs ) Gsh2GetPixelShaderGprs;
    decltype( &::GSH2GetVertexShaderStackEntries ) Gsh2GetVertexShaderStackEntries;
    decltype( &::GSH2GetGeometryShaderStackEntries ) Gsh2GetGeometryShaderStackEntries;
    decltype( &::GSH2GetPixelShaderStackEntries ) Gsh2GetPixelShaderStackEntries;

    decltype( &::GSH2CreateSetFetchShaderDL ) Gsh2CreateSetFetchShaderDl;
    decltype( &::GSH2CreateSetVertexShaderDL ) Gsh2CreateSetVertexShaderDl;
    decltype( &::GSH2CreateSetGeometryShaderDL ) Gsh2CreateSetGeometryShaderDl;
    decltype( &::GSH2CreateSetPixelShaderDL ) Gsh2CreateSetPixelShaderDl;
    decltype( &::GSH2CreateSetComputeShaderDL ) Gsh2CreateSetComputeShaderDl;
    decltype( &::GSH2FreeDL ) Gsh2FreeDl;
};

}
}
