﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/util/util_StringView.h>

#include <gfxTool_Common.h>

struct nngfxToolShaderCompilerCompileArg;

namespace nn {
namespace gfxTool {

struct ShaderSource
{
    Custom< std::string >::Type includeExpandedSource;
    Custom< std::string >::Type variationBufferSource;
    nn::util::string_view beforeVariationBufferView;
    nn::util::string_view afterVariationBufferView;
};

class ShaderSourceManager
{
public:
    void Initialize( const nngfxToolShaderCompilerCompileArg* pArg );

    const std::shared_ptr< ShaderSource >& GetShaderSource( ShaderStage stage ) const
    {
        return m_pSources[ static_cast< int >( stage ) ];
    }

private:
    std::shared_ptr< ShaderSource > m_pSources[ ShaderStage::End ];
};

}
}
