﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <memory>
#include <string>
#include <vector>
#include <list>

#include <nn/gfx/gfx_ShaderInfoData.h>

#include <nn/gfxTool/gfxTool_ShaderUtils.h>

#include <gfxTool_Common.h>

namespace nn {
namespace gfxTool {

class OptionOutput;

struct SourceArrayOutput
{
    Custom< std::vector< uint32_t > >::Type codeSizeArray;
    Custom< std::vector< nn::gfx::detail::Ptr< const void > > >::Type codeArray;
};

struct Gx2Introspection
{
    std::shared_ptr< void > shaderPtr;
    std::shared_ptr< void > copyShaderPtr;
    Custom< std::vector< GX2UniformBlock > >::Type uniformBlocks;
    Custom< std::vector< GX2UniformVar > >::Type uniformVars;
    Custom< std::vector< GX2UniformInitialValue > >::Type initialValues;
    Custom< std::vector< GX2LoopVar > >::Type loopVars;
    Custom< std::vector< GX2SamplerVar > >::Type samplerVars;
    Custom< std::vector< GX2AttribVar > >::Type attribVars;
    Custom< std::list< Custom< std::string >::Type > >::Type names;
};

class ProgramOutput
    : private nngfxToolShaderCompilerShaderProgramOutput
{
public:
    ProgramOutput();

    ~ProgramOutput();

    nngfxToolShaderCompilerShaderProgramOutput* GetOutput()
    {
        return static_cast< nngfxToolShaderCompilerShaderProgramOutput* >( this );
    }

    nn::gfx::ShaderInfoData* GetInfo()
    {
        return &m_Info;
    }

    void Initialize( const nngfxToolShaderCompilerCompileArg* pArg );

    void SetCode( ShaderStage stage, std::shared_ptr< void > pCode );
    void SetShaderCode( ShaderStage stage, std::shared_ptr< void > pCode, size_t codeSize );
    void SetShaderCode( ShaderStage stage, std::shared_ptr< void > pCode,
        size_t codeSize, size_t decompressedCodeSize );
    void SetSourceArrayCode( ShaderStage stage, std::shared_ptr< SourceArrayOutput > pSourceArray );

    void SetAdditionalData( std::shared_ptr< void > pAdditionalData )
    {
        m_AdditionalData.push_back( pAdditionalData );
    }

    Custom< std::vector< nngfxToolShaderCompilerOptionOutput > >::Type& GetOptionOutputArray()
    {
        return m_OptionOutputArrayRaw;
    }

    void AddOptionOutput( nngfxToolShaderCompilerOptionOutputType type, std::shared_ptr< void > pOutput );

    void* GetOptionOutput( nngfxToolShaderCompilerOptionOutputType type );

private:
    nn::gfx::ShaderInfoData m_Info;
    nn::gfx::ShaderCode m_ShaderCode[ ShaderStage::End ];
    nn::gfx::SourceArrayCode m_SourceArrayCode[ ShaderStage::End ];

    std::shared_ptr< void > m_pCode[ ShaderStage::End ];
    std::shared_ptr< SourceArrayOutput > m_pSourceArrayOutput[ ShaderStage::End ];

    Custom< std::vector< std::shared_ptr< void > > >::Type m_AdditionalData;

    Custom< std::vector< nngfxToolShaderCompilerOptionOutput > >::Type m_OptionOutputArrayRaw;
    Custom< std::vector< std::shared_ptr< void > > >::Type m_Options;
};

}
}
