﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <gfxTool_Common.h>

namespace nn {
namespace gfxTool {

class OptionOutputStageNvn
    : private nngfxToolShaderCompilerOptionOutputStageNvn
{
public:
    OptionOutputStageNvn()
        : nngfxToolShaderCompilerOptionOutputStageNvn()
    {
    }

    nngfxToolShaderCompilerOptionOutputStageNvn* GetOutput()
    {
        return static_cast< nngfxToolShaderCompilerOptionOutputStageNvn* >( this );
    }
};

class OptionOutputProgramNvn
    : private nngfxToolShaderCompilerOptionOutputProgramNvn
{
public:
    OptionOutputProgramNvn()
        : nngfxToolShaderCompilerOptionOutputProgramNvn()
    {
    }

    void Initialize( const nngfxToolShaderCompilerCompileArg* pArg )
    {
        static nngfxToolShaderCompilerOptionOutputStageNvn*
            nngfxToolShaderCompilerOptionOutputProgramNvn::* const s_pStages[] =
        {
            &nngfxToolShaderCompilerOptionOutputProgramNvn::pVertexStageOutput,
            &nngfxToolShaderCompilerOptionOutputProgramNvn::pHullStageOutput,
            &nngfxToolShaderCompilerOptionOutputProgramNvn::pDomainStageOutput,
            &nngfxToolShaderCompilerOptionOutputProgramNvn::pGeometryStageOutput,
            &nngfxToolShaderCompilerOptionOutputProgramNvn::pPixelStageOutput,
            &nngfxToolShaderCompilerOptionOutputProgramNvn::pComputeStageOutput
        };
        for( int idxStage = 0; idxStage < static_cast< int >( ShaderStage::End ); ++idxStage )
        {
            if( GetStageSource( pArg, static_cast< ShaderStage >( idxStage ) ).pValue )
            {
                this->*s_pStages[ idxStage ] = m_StageOutput[ idxStage ].GetOutput();
            }
        }
    }

    nngfxToolShaderCompilerOptionOutputProgramNvn* GetOutput()
    {
        return static_cast< nngfxToolShaderCompilerOptionOutputProgramNvn* >( this );
    }

    OptionOutputStageNvn* GetOptionOutputStageNvn( ShaderStage stage )
    {
        return m_StageOutput + static_cast< int >( stage );
    }

private:
   OptionOutputStageNvn m_StageOutput[ ShaderStage::End ];
};

}
}
