﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <vector>

#include <gfxTool_Common.h>

namespace nn {
namespace gfxTool {

class GroupSource
{
public:
    virtual ~GroupSource()
    {
    }

    const Custom< std::vector< Custom< std::string >::Type > >::Type& GetSources() const
    {
        return m_Sources;
    }

protected:
    Custom< std::vector< Custom< std::string >::Type > >::Type m_Sources;
};

class VariationConstantSource
    : public GroupSource
{
public:
    template< nngfxToolShaderCompilerShaderSourceFormat Format >
    void Initialize( const nngfxToolShaderCompilerCompileArg* pArg,
        const Custom< std::vector< int > >::Type* pGroupToHeadVariationTable, ShaderStage stage );
};

class PreprocessorDefinitionSource
    : public GroupSource
{
public:
    void Initialize( const nngfxToolShaderCompilerCompileArg* pArg,
        const Custom< std::vector< int > >::Type* pGroupToHeadVariationTable, ShaderStage stage );
};

}
}
