﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <nn/nn_Macro.h>
#include <nn/nn_Windows.h>

namespace nn {
namespace gfxTool {

class GlContext
{
    NN_DISALLOW_COPY( GlContext );

public:
    GlContext()
        : m_hGlRc()
        , m_hDc()
    {
    }

    ~GlContext();

    const void* GetHandle() const
    {
        return m_hGlRc;
    }

    bool IsInitialized() const
    {
        return m_hGlRc != nullptr;
    }

    void Initialize( HDC hDc, HGLRC hSharedRc );

    void MakeCurrent() const;

private:
    HGLRC m_hGlRc;
    HDC m_hDc;
};

}
}
