﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <memory>
#include <string>

#include <gfxTool_Common.h>
#include <gfxTool_VariationOutput.h>
#include <gfxTool_ProgramOutput.h>

namespace nn {
namespace gfxTool {

struct ShaderSource;
class VariationConstantSource;
class PreprocessorDefinitionSource;
class VariationOutput;

struct SourceOutput
{
    std::shared_ptr< Custom< std::string >::Type > pGlslVersion;
    std::shared_ptr< Custom< std::string >::Type > pGlobalPreprocessorSource;
    std::shared_ptr< ShaderSource > pShaderSource[ ShaderStage::End ];
    std::shared_ptr< VariationConstantSource > pVariationConstantSource[ ShaderStage::End ];
    std::shared_ptr< PreprocessorDefinitionSource > pPreprocessorDefinitionSource[ ShaderStage::End ];
};

class CompileOutput
    : public nngfxToolShaderCompilerCompileOutput
{
public:
    CompileOutput();

    ~CompileOutput();

    nngfxToolShaderCompilerCompileOutput* GetOutput()
    {
        return static_cast< nngfxToolShaderCompilerCompileOutput* >( this );
    }

    VariationOutput* GetVariationOutput( int idxVariation )
    {
        return &m_pVariationOutputArray[ idxVariation ];
    }

    SourceOutput* GetSourceOutput()
    {
        return m_pSourceOutput.get();
    }

    void Initialize( const nngfxToolShaderCompilerCompileArg* pArg );

    static CompileOutput* Create()
    {
        return new CompileOutput();
    }

    static nngfxToolResultCode Delete( CompileOutput* ptr )
    {
        if( ptr == nullptr )
        {
            return nngfxToolResultCode_InvalidHandle;
        }
        delete ptr;
        return nngfxToolResultCode_Succeeded;
    }

    static CompileOutput* DownCast( nngfxToolShaderCompilerCompileOutput* pOutput )
    {
        return static_cast< CompileOutput* >( pOutput );
    }

private:
    Custom< std::unique_ptr< nngfxToolShaderCompilerVariationOutput[] > >::Type m_pVariationOutputArrayRaw;
    Custom< std::unique_ptr< VariationOutput[] > >::Type m_pVariationOutputArray;

    Custom< std::unique_ptr< SourceOutput > >::Type m_pSourceOutput;
};

}
}
