﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <gfxTool_CompileOption.h>

namespace nn {
namespace gfxTool {

template< nngfxToolShaderCompilerOptionType OptionType >
class CompileOption;

class CompileOptionManager
{
public:
    CompileOptionManager();

    ~CompileOptionManager();

    void Initialize( const nngfxToolShaderCompilerCompileArg* pArg );

    template< nngfxToolShaderCompilerOptionType OptionType >
    const CompileOption< OptionType >* GetCompileOption() const
    {
        return StaticCastAuto( m_pCompileOptions[ OptionType ].get() );
    }

private:
    Custom< std::unique_ptr< CompileOptionBase > >::Type m_pCompileOptions[ 5 ];
};

}
}
