﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/gfx/gfx_ShaderInfoData.h>

#include <nn/gfxTool/gfxTool_Custom.h>
#include <nn/gfxTool/gfxTool_Enum.h>
#include <nn/gfxTool/gfxTool_Error.h>
#include <nn/gfxTool/gfxTool_ResultCode.h>

#include <nn/gfxTool/gfxTool_ShaderCompilerApi.h>
#include <nn/gfxTool/gfxTool_ShaderCompilerApi-gx.h>
#include <nn/gfxTool/gfxTool_ShaderCompilerApi-nvn.h>
#include <nn/gfxTool/gfxTool_ShaderCompilerApi-d3d.h>
#include <nn/gfxTool/gfxTool_ShaderCompilerApi-vk.h>

namespace nn {
namespace gfxTool {

inline const nngfxToolString& GetStageSource(
    const nngfxToolShaderCompilerCompileArg* pArg, ShaderStage stage )
{
    static const nngfxToolString
        nngfxToolShaderCompilerCompileArg::* const s_pStageSource[ ShaderStage::End ] =
    {
        &nngfxToolShaderCompilerCompileArg::vertexShaderSource,
        &nngfxToolShaderCompilerCompileArg::hullShaderSource,
        &nngfxToolShaderCompilerCompileArg::domainShaderSource,
        &nngfxToolShaderCompilerCompileArg::geometryShaderSource,
        &nngfxToolShaderCompilerCompileArg::pixelShaderSource,
        &nngfxToolShaderCompilerCompileArg::computeShaderSource
    };

    return pArg->*( s_pStageSource[ static_cast< int >( stage ) ] );
}

inline const nngfxToolShaderCompilerVariationDefinition* GetStageVariationDefinition(
    const nngfxToolShaderCompilerVariationDefinitionArg* pArg, ShaderStage stage )
{
    static const nngfxToolShaderCompilerVariationDefinition*
        nngfxToolShaderCompilerVariationDefinitionArg::*
        const s_pStageVariationDefinition[ ShaderStage::End ] =
    {
        &nngfxToolShaderCompilerVariationDefinitionArg::pVertexShaderVariationDefinition,
        &nngfxToolShaderCompilerVariationDefinitionArg::pHullShaderVariationDefinition,
        &nngfxToolShaderCompilerVariationDefinitionArg::pDomainShaderVariationDefinition,
        &nngfxToolShaderCompilerVariationDefinitionArg::pGeometryShaderVariationDefinition,
        &nngfxToolShaderCompilerVariationDefinitionArg::pPixelShaderVariationDefinition,
        &nngfxToolShaderCompilerVariationDefinitionArg::pComputeShaderVariationDefinition
    };

    return pArg == nullptr ? nullptr : pArg->*( s_pStageVariationDefinition[ static_cast< int >( stage ) ] );
}

inline const nngfxToolShaderCompilerVariationValue* GetStageVariationValue(
    const nngfxToolShaderCompilerVariationValueArg* pArg, ShaderStage stage )
{
    static const nngfxToolShaderCompilerVariationValue*
        nngfxToolShaderCompilerVariationValueArg::*
        const s_pStageVariationValue[ ShaderStage::End ] =
    {
        &nngfxToolShaderCompilerVariationValueArg::pVertexShaderVariationValue,
        &nngfxToolShaderCompilerVariationValueArg::pHullShaderVariationValue,
        &nngfxToolShaderCompilerVariationValueArg::pDomainShaderVariationValue,
        &nngfxToolShaderCompilerVariationValueArg::pGeometryShaderVariationValue,
        &nngfxToolShaderCompilerVariationValueArg::pPixelShaderVariationValue,
        &nngfxToolShaderCompilerVariationValueArg::pComputeShaderVariationValue
    };

    return pArg == nullptr ? nullptr : pArg->*( s_pStageVariationValue[ static_cast< int >( stage ) ] );
}

inline nn::gfx::detail::Ptr< const void >* GetStageCodePtr(
    nn::gfx::ShaderInfoData* pInfo, ShaderStage stage )
{
    static nn::gfx::detail::Ptr< const void > nn::gfx::ShaderInfoData::* const s_pStageCode[] =
    {
        &nn::gfx::ShaderInfoData::pVertexShaderCode,
        &nn::gfx::ShaderInfoData::pHullShaderCode,
        &nn::gfx::ShaderInfoData::pDomainShaderCode,
        &nn::gfx::ShaderInfoData::pGeometryShaderCode,
        &nn::gfx::ShaderInfoData::pPixelShaderCode,
        &nn::gfx::ShaderInfoData::pComputeShaderCode
    };
    return pInfo == nullptr ? nullptr : reinterpret_cast< nn::gfx::detail::Ptr< const void >* >(
        &( pInfo->*s_pStageCode[ static_cast< int >( stage ) ] ) );
}

inline bool IsSamplerType( nngfxToolShaderCompilerReflectionVariableType type )
{
    return type >= nngfxToolShaderCompilerReflectionVariableType_Sampler1D
        && type <= nngfxToolShaderCompilerReflectionVariableType_UintSamplerCubeMapArray;
}

inline bool IsImageType( nngfxToolShaderCompilerReflectionVariableType type )
{
    return type >= nngfxToolShaderCompilerReflectionVariableType_Image1D
        && type <= nngfxToolShaderCompilerReflectionVariableType_UintImage2DRect;
}

inline bool IsSeparateTextureType( nngfxToolShaderCompilerReflectionVariableType type )
{
    return type >= nngfxToolShaderCompilerReflectionVariableType_Texture1D
        && type <= nngfxToolShaderCompilerReflectionVariableType_UintTextureCubeMapArray;
}

inline bool IsSeparateSamplerType( nngfxToolShaderCompilerReflectionVariableType type )
{
    return type == nngfxToolShaderCompilerReflectionVariableType_Sampler;
}

inline Custom< std::string >::Type ToString( const nngfxToolString& value )
{
    return Custom< std::string >::Type( value.pValue, value.length );
}

void* GetShaderCompilerModuleHandle();

inline bool HasSource( nngfxToolShaderCompilerCodeType codeType )
{
    return codeType == nngfxToolShaderCompilerCodeType_Source ||
        codeType == nngfxToolShaderCompilerCodeType_Binary_Source ||
        codeType == nngfxToolShaderCompilerCodeType_Ir_Source;
}

inline bool HasIr( nngfxToolShaderCompilerCodeType codeType )
{
    return codeType == nngfxToolShaderCompilerCodeType_Binary_Ir ||
        codeType == nngfxToolShaderCompilerCodeType_Ir_Source ||
        codeType == nngfxToolShaderCompilerCodeType_Ir;
}

inline bool HasBinary( nngfxToolShaderCompilerCodeType codeType )
{
    return codeType == nngfxToolShaderCompilerCodeType_Binary ||
        codeType == nngfxToolShaderCompilerCodeType_Binary_Source ||
        codeType == nngfxToolShaderCompilerCodeType_Binary_Ir;
}

}
}
