﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/nn_Macro.h>
#include <nn/gfxTool/gfxTool_Error.h>
#include <gfxTool_HlslCrossCompilerReflection.h>

namespace nn { namespace gfxTool {
    HlslShaderCompilerReflection::HlslShaderCompilerReflection()
    {
    }

    HlslShaderCompilerReflection::~HlslShaderCompilerReflection()
    {
    }

    void HlslShaderCompilerReflection::OnDiagnostics(const std::string &error, int line, bool isError)
    {
        NN_UNUSED( line );
        if( isError )
        {
            NN_GFXTOOL_PRINT_ERROR( "%s", error.c_str() );
            exit( 1 );
        }
        else
        {
            NN_GFXTOOL_PRINT_WARNING( "%s", error.c_str() );
        }
    }

    void HlslShaderCompilerReflection::OnInputBinding(const std::string &name, int bindIndex)
    {
        m_InputBindings.push_back( InputBinding() );
        m_InputBindings.back().name = name;
        m_InputBindings.back().bindIndex = bindIndex;
    }

    bool HlslShaderCompilerReflection::OnConstantBuffer(const std::string &name, size_t bufferSize, size_t memberCount)
    {
        m_ConstantBuffers.push_back( ConstantBuffer() );
        m_ConstantBuffers.back().bufferSize = bufferSize;
        m_ConstantBuffers.back().name = name;
        m_ConstantBuffers.back().memberCount = memberCount;
        return true;
    }

    bool HlslShaderCompilerReflection::OnConstant(const std::string &name, int bindIndex, SHADER_VARIABLE_TYPE cType, int rows, int cols, bool isMatrix, int arraySize)
    {
        m_Constants.push_back( Constant() );
        m_Constants.back().name = name;
        m_Constants.back().arraySize = arraySize;
        m_Constants.back().bindIndex = bindIndex;
        m_Constants.back().variableType = cType;
        m_Constants.back().rows = rows;
        m_Constants.back().cols = cols;
        m_Constants.back().isMatrix = isMatrix;
        return true;
    }

    void HlslShaderCompilerReflection::OnConstantBufferBinding(const std::string &name, int bindIndex)
    {
        m_ConstantBufferBindings.push_back( ConstantBufferBinding() );
        m_ConstantBufferBindings.back().bindIndex = bindIndex;
        m_ConstantBufferBindings.back().name = name;
    }

    void HlslShaderCompilerReflection::OnTextureBinding(const std::string &name, int bindIndex, int samplerIndex, HLSLCC_TEX_DIMENSION dim, bool isUAV)
    {
        m_TextureBindings.push_back( TextureBinding() );
        m_TextureBindings.back().bindIndex = bindIndex;
        m_TextureBindings.back().samplerIndex = samplerIndex;
        m_TextureBindings.back().dim = dim;
        m_TextureBindings.back().isUAV = isUAV;
        m_TextureBindings.back().name = name;
    }

    void HlslShaderCompilerReflection::OnBufferBinding(const std::string &name, int bindIndex, bool isUAV)
    {
        m_BufferBindings.push_back( BufferBinding() );
        m_BufferBindings.back().bindIndex = bindIndex;
        m_BufferBindings.back().isUav = isUAV;
        m_BufferBindings.back().name = name;
    }

    void HlslShaderCompilerReflection::OnThreadGroupSize(unsigned int xSize, unsigned int ySize, unsigned int zSize)
    {
        m_ThreadGroupSizeX = xSize;
        m_ThreadGroupSizeY = ySize;
        m_ThreadGroupSizeZ = zSize;
    }
}}
