﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfxTool/gfxTool_Enum.h>
#include <nn/gfxTool/gfxTool_CommandLineParser.h>

namespace nn {
namespace gfxTool {

class HlslShaderCompilerOptionParser : protected nn::gfxTool::CommandLineParser
{
public:
    //! @brief コマンドラインオプションを定義する構造体です。
    struct CommandLineOptionDefinitions
    {
        nn::gfxTool::CommandLineOption<> version;
        nn::gfxTool::CommandLineOption<> help;
        nn::gfxTool::CommandLineOption<> silent;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type> output;
        nn::gfxTool::CommandLineOption<> reflection;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type[]> hlslccOptionFlags;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type[]> hlslCompileOptionFlags;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type> entryPoint;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type> shaderModel;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type[]> preprocessorDefinitions;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type[]> includeDirectories;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type> systemBufferBinding;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type> shiftPatchLocation;
    };

    HlslShaderCompilerOptionParser();

    virtual ~HlslShaderCompilerOptionParser()
    {
    }

    //! @brief 位置引数を取得します。
    const nn::gfxTool::Custom<std::vector<nn::gfxTool::Custom<std::string>::Type>>::Type& GetInputArgs() const
    {
        return m_InputArgArray;
    }

    //! @brief コマンドラインオプションを取得します。
    const CommandLineOptionDefinitions& GetCommandLineOptionDefinitions() const
    {
        return m_OptionDefinitions;
    }

    //! @brief コマンドラインオプションを取得します。
    CommandLineOptionDefinitions& GetCommandLineOptionDefinitions()
    {
        return m_OptionDefinitions;
    }

    //!< @brief パースします。
    void Parse()
    {
        const char** strPtrArray = new( const char* [m_RawOptions.size()] );
        for( int idx = 0; idx < static_cast<int>( m_RawOptions.size() ); ++idx )
        {
            strPtrArray[idx] = reinterpret_cast<const char* const>( m_RawOptions[idx].c_str() );
        }
        nn::gfxTool::CommandLineParser::Parse( static_cast< int >( m_RawOptions.size() ), strPtrArray );
        delete[] strPtrArray;
    }

    //!< @brief ヘルプを表示します。
    void PrintHelp( const char* pToolName, const char* pToolDescription )
    {
        nn::gfxTool::CommandLineParser::PrintHelp( pToolName, pToolDescription );
    }

    void SetOptions( int argc, char** argv )
    {
        for( int idxArg = 0; idxArg < argc; ++idxArg )
        {
            m_RawOptions.push_back( std::string( argv[idxArg] ) );
        }
    }

protected:
    //! @brief オプションの定義と値を保持するオブジェクトです。
    CommandLineOptionDefinitions	m_OptionDefinitions;

    //! @brief 位置引数（オプションを伴わない引数）の配列です。
    nn::gfxTool::Custom<std::vector<nn::gfxTool::Custom<std::string >::Type>>::Type	m_InputArgArray;	//!< オプションの状態と値を保持している配列です。

    std::vector<std::string>	m_RawOptions;

};

}
}
