﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <Windows.h>

#include <vector>
#include <string>
#include <algorithm>

namespace nn {
namespace gfxTool {

class HlslShaderCompilerManager
{
public:
    HlslShaderCompilerManager()
    {
    }

    virtual ~HlslShaderCompilerManager()
    {
    }

    void AddFile( const char* inputFile )
    {
        char fullpath[_MAX_PATH];
        _fullpath(fullpath, inputFile, _MAX_PATH);
        m_InputFileArray.push_back( std::string( fullpath ) );
        auto& file = m_InputFileArray.back();
        std::replace(file.begin(), file.end(), L'\\', L'/');
    }

private:
    std::vector<std::string> m_InputFileArray;

};

}
}
