/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

#version 330

layout(location = 0) in vec3 a_Position;
layout(location = 1) in vec3 a_Normal;
layout(location = 2) in vec2 a_UV;
layout(location = 3) in ivec4 a_Index;
layout(location = 4) in vec4 a_Weight;

out Raster
{
    vec3 normal;
    vec4 color;
    vec2 uv;
} OUT;

layout(std140) uniform Skeleton
{
    vec4 mtxPalette[256];
};

layout(std140) uniform Shape
{
    vec4 shapeMtx[3];
    int skinningVertexCount;
};

layout(std140) uniform View
{
    vec4 projMtx[4];
    vec4 cameraMtx[3];
    vec4 lightPos;
};

void main()
{
    const mat4 viewFix = mat4(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, -50, 1);
    const mat4 projFix = mat4(2.253270, 0, 0, 0, 0, 2.414210, 0, 0, 0, 0, -1, -1, 0, 0, -1, 0);

    vec4 pos_l = vec4(a_Position, 1);
    vec4 pos_w = vec4(0, 0, 0, 1);
    vec3 nrm_w = vec3(0, 0, 0);
    float weightSum = 0;

    vec3 anormal = normalize( a_Normal );

    if (skinningVertexCount == 0)
    {
        pos_w.x = dot(shapeMtx[0], pos_l);
        pos_w.y = dot(shapeMtx[1], pos_l);
        pos_w.z = dot(shapeMtx[2], pos_l);
        nrm_w.x = dot(shapeMtx[0].xyz, anormal);
        nrm_w.y = dot(shapeMtx[1].xyz, anormal);
        nrm_w.z = dot(shapeMtx[2].xyz, anormal);
    }
    else if (skinningVertexCount == 1)
    {
        int mtxIndex = a_Index.x * 3;
        pos_w.x = dot(mtxPalette[mtxIndex + 0], pos_l);
        pos_w.y = dot(mtxPalette[mtxIndex + 1], pos_l);
        pos_w.z = dot(mtxPalette[mtxIndex + 2], pos_l);
        nrm_w.x = dot(mtxPalette[mtxIndex + 0].xyz, a_Normal);
        nrm_w.y = dot(mtxPalette[mtxIndex + 1].xyz, a_Normal);
        nrm_w.z = dot(mtxPalette[mtxIndex + 2].xyz, a_Normal);
    }
    else
    {
        for (int i = 0; i < skinningVertexCount; ++i)
        {
            int mtxIndex = a_Index[i] * 3;
            float weight = a_Weight[i];
            weightSum += weight;
            pos_w.x += weight * dot(mtxPalette[mtxIndex + 0], pos_l);
            pos_w.y += weight * dot(mtxPalette[mtxIndex + 1], pos_l);
            pos_w.z += weight * dot(mtxPalette[mtxIndex + 2], pos_l);
            nrm_w.x += weight * dot(mtxPalette[mtxIndex + 0].xyz, a_Normal);
            nrm_w.y += weight * dot(mtxPalette[mtxIndex + 1].xyz, a_Normal);
            nrm_w.z += weight * dot(mtxPalette[mtxIndex + 2].xyz, a_Normal);
        }
    }

#if 0
    vec4 viewPos = viewFix * pos_w;
    vec4 outPos = projFix * viewPos;
    gl_Position = outPos;
#else
    vec4 pos_v;
    pos_v.x = dot(cameraMtx[0], pos_w);
    pos_v.y = dot(cameraMtx[1], pos_w);
    pos_v.z = dot(cameraMtx[2], pos_w);
    pos_v.w = 1;

    gl_Position.x = dot(projMtx[0], pos_v);
    gl_Position.y = dot(projMtx[1], pos_v);
    gl_Position.z = dot(projMtx[2], pos_v);
    gl_Position.w = dot(projMtx[3], pos_v);
#endif
    OUT.normal.x = dot(cameraMtx[0].xyz, nrm_w);
    OUT.normal.y = dot(cameraMtx[1].xyz, nrm_w);
    OUT.normal.z = dot(cameraMtx[2].xyz, nrm_w);
    OUT.normal = normalize( OUT.normal );

    OUT.uv = a_UV;

    vec4 light_v;
    light_v.x = dot(cameraMtx[0], lightPos);
    light_v.y = dot(cameraMtx[1], lightPos);
    light_v.z = dot(cameraMtx[2], lightPos);
    light_v.w = 1;

    vec3 viewLightVec   = normalize( light_v.xyz - pos_v.xyz );
    float diffuse = dot( viewLightVec, OUT.normal );
    diffuse = clamp( diffuse,  0.3,  1.0 );

    OUT.color.r = diffuse;
    OUT.color.g = diffuse;
    OUT.color.b = diffuse;
    OUT.color.a = 1.0;
}


















