/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/
uniform vec2        TextureSize0;
uniform float       Weight[5];
uniform sampler2D   Texture0;

void main()
{
    vec2 oy_1 = vec2( 0.0, 1.5 / TextureSize0.y );
    vec2 oy_2 = vec2( 0.0, 3.5 / TextureSize0.y );
    vec2 oy_3 = vec2( 0.0, 5.5 / TextureSize0.y );
    vec2 oy_4 = vec2( 0.0, 7.5 / TextureSize0.y );

    gl_FragColor =  Weight[4] * texture2D( Texture0, gl_TexCoord[0].st - oy_4 );
    gl_FragColor += Weight[3] * texture2D( Texture0, gl_TexCoord[0].st - oy_3 );
    gl_FragColor += Weight[2] * texture2D( Texture0, gl_TexCoord[0].st - oy_2 );
    gl_FragColor += Weight[1] * texture2D( Texture0, gl_TexCoord[0].st - oy_1 );
    gl_FragColor += Weight[0] * texture2D( Texture0, gl_TexCoord[0].st );
    gl_FragColor += Weight[1] * texture2D( Texture0, gl_TexCoord[0].st + oy_1 );
    gl_FragColor += Weight[2] * texture2D( Texture0, gl_TexCoord[0].st + oy_2 );
    gl_FragColor += Weight[3] * texture2D( Texture0, gl_TexCoord[0].st + oy_3 );
    gl_FragColor += Weight[4] * texture2D( Texture0, gl_TexCoord[0].st + oy_4 );
}
