/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/
uniform vec2        TextureSize0;
uniform sampler2D   Texture0;

void main()
{
    vec2      vTexOffset_1 = vec2( 1.5 / TextureSize0.x, 1.5 / TextureSize0.y);
    vec2      vTexOffset_2 = vec2( 3.5 / TextureSize0.x, 3.5 / TextureSize0.y);

    vec2 ox_1 = vec2( vTexOffset_1.x, 0.0 );
    vec2 oy_1 = vec2( 0.0, vTexOffset_1.y );
    vec2 ox_2 = vec2( vTexOffset_2.x, 0.0 );
    vec2 oy_2 = vec2( 0.0, vTexOffset_2.y );

    vec2 oo = gl_TexCoord[0].st - oy_2;
    gl_FragColor  = 1 * 1 * texture2D( Texture0, oo - ox_2 );
    gl_FragColor += 4 * 1 * texture2D( Texture0, oo - ox_1 );
    gl_FragColor += 6 * 1 * texture2D( Texture0, oo );
    gl_FragColor += 4 * 1 * texture2D( Texture0, oo + ox_1 );
    gl_FragColor += 1 * 1 * texture2D( Texture0, oo + ox_2 );
    oo = gl_TexCoord[0].st - oy_1;
    gl_FragColor += 1 * 4 * texture2D( Texture0, oo - ox_2 );
    gl_FragColor += 4 * 4 * texture2D( Texture0, oo - ox_1 );
    gl_FragColor += 6 * 4 * texture2D( Texture0, oo );
    gl_FragColor += 4 * 4 * texture2D( Texture0, oo + ox_1 );
    gl_FragColor += 1 * 4 * texture2D( Texture0, oo + ox_2 );
    oo = gl_TexCoord[0].st;
    gl_FragColor += 1 * 6 * texture2D( Texture0, oo - ox_2 );
    gl_FragColor += 4 * 6 * texture2D( Texture0, oo - ox_1 );
    gl_FragColor += 6 * 6 * texture2D( Texture0, oo );
    gl_FragColor += 4 * 6 * texture2D( Texture0, oo + ox_1 );
    gl_FragColor += 1 * 6 * texture2D( Texture0, oo + ox_2 );
    oo = gl_TexCoord[0].st + oy_1;
    gl_FragColor += 1 * 4 * texture2D( Texture0, oo - ox_2 );
    gl_FragColor += 4 * 4 * texture2D( Texture0, oo - ox_1 );
    gl_FragColor += 6 * 4 * texture2D( Texture0, oo );
    gl_FragColor += 4 * 4 * texture2D( Texture0, oo + ox_1 );
    gl_FragColor += 1 * 4 * texture2D( Texture0, oo + ox_2 );
    oo = gl_TexCoord[0].st + oy_2;
    gl_FragColor += 1 * 1 * texture2D( Texture0, oo - ox_2 );
    gl_FragColor += 4 * 1 * texture2D( Texture0, oo - ox_1 );
    gl_FragColor += 6 * 1 * texture2D( Texture0, oo );
    gl_FragColor += 4 * 1 * texture2D( Texture0, oo + ox_1 );
    gl_FragColor += 1 * 1 * texture2D( Texture0, oo + ox_2 );

    gl_FragColor *= 0.00390625; // gl_FragColor /= 256;
}
