﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <System.h>
#include <FrameBuffer.h>
#include <ScreenDrawer.h>

namespace nw      {
namespace eftdemo {


#define GLARE_BUFFER_MAX        (5)


//---------------------------------------------------------------------------
//! @brief      グレアエフェクトクラス
//---------------------------------------------------------------------------
class GlareEffect
{
public:
    //---------------------------------------------------------------------------
    //! @brief        コンストラクタです。
    //---------------------------------------------------------------------------
    GlareEffect();

    //---------------------------------------------------------------------------
    //! @brief        初期化処理です。
    //---------------------------------------------------------------------------
    void Initialize( nw::ut::MemoryAllocator* allocator, s32 width, s32 height );

    //---------------------------------------------------------------------------
    //! @brief        終了処理です。
    //---------------------------------------------------------------------------
    void Finalize();

    //---------------------------------------------------------------------------
    //! @brief        描画処理です。
    //---------------------------------------------------------------------------
    void Draw( nw::eftdemo::ScreenDrawer* drawer, nw::eftdemo::FrameBuffer* currentFrameBuffer, u32 glareNum );

private:
    nw::ut::MemoryAllocator*    m_Allocator;
    FrameBuffer                 mFrameBufferTextureGlareX[GLARE_BUFFER_MAX];   //!< フレームバッファ
    FrameBuffer                 mFrameBufferTextureGlareY[GLARE_BUFFER_MAX];   //!< フレームバッファ
    f32                         mWeightValue[GLARE_BUFFER_MAX][ScreenDrawer::GAUSS_LENGTH];  //! ガウスフィルタの重み
};


} // namespace eftdemo
} // namespace nw
