﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/g3d.h>
#include <nw/dev.h>

#include <ModelUtility.h>
#include <nw/eft/eftut2_Heap.h>
#include <nw/eft/eftcom_Protocol.h>
#include <nw/eft/eftvw2_ModelPreview.h>
#include <nw/eft/eftvw2_ViewerSystem.h>

//---------------------------------------------------------------------------
//! @brief        エフェクトビューア モデル プレビュー クラス
//---------------------------------------------------------------------------
class G3dModelPreview : public nw::eftvw2::ModelPreview
{
public:
    //---------------------------------------------------------------------------
    //! @brief  モデルプレビュークラスのインスタンスを生成します。
    //---------------------------------------------------------------------------
    static nw::eftvw2::Preview* CreateModelPreview( nw::eft2::Heap* heap, nw::eftvw2::ViewerSystem* viewerSystem, void* binary, u32 binarySize, nw::eftcom::Guid guid );

    //---------------------------------------------------------------------------
    //! @brief  モデルプレビュークラスのインスタンスを破棄します。
    //---------------------------------------------------------------------------
    static void DestroyModelPreview( nw::eft2::Heap* heap, nw::eftvw2::Preview* preview );

private:
    //---------------------------------------------------------------------------
    //! @brief  コンストラクタです。
    //---------------------------------------------------------------------------
    G3dModelPreview();

    //---------------------------------------------------------------------------
    //! @brief  モデルプレビュークラスの初期化します。
    //---------------------------------------------------------------------------
    bool InitializeModelPreview( nw::eftut2::NwHeap* heap, void* binary, u32 binarySize );

    //---------------------------------------------------------------------------
    //! @brief  モデルプレビュークラスの終了処理をします。
    //---------------------------------------------------------------------------
    void FinalizeModelPreview( nw::eft2::Heap* heap );

    //---------------------------------------------------------------------------
    //! @brief  モデル情報構造体を取得します。
    //---------------------------------------------------------------------------
    const void* GetModelInfo() { return mpModelDataMessage; }

    //---------------------------------------------------------------------------
    //! @brief   パケットサイズを取得
    //---------------------------------------------------------------------------
    size_t GetModelInfoSize() { return mpModelDataMessageSize; }

public:
    //---------------------------------------------------------------------------
    //! @brief  プレビュー計算処理です。
    //---------------------------------------------------------------------------
    virtual void Calc( bool bPause, f32 frameRate, const nw::math::MTX34& centerMatrix, const nw::math::MTX34& viewMatrix );

    //---------------------------------------------------------------------------
    //! @brief  ブロック計算処理です。
    //---------------------------------------------------------------------------
    void CalcBlock( const nw::g3d::math::Mtx34* viewMtx,
                    const nw::g3d::math::Mtx44* projMtx,
                    const nw::g3d::Vec4* lightPos,
                    nw::eftdemo::SimpleShader::ViewId id );

    //---------------------------------------------------------------------------
    //! @brief  プレビュー描画処理です。
    //---------------------------------------------------------------------------
    void Draw( nw::eftdemo::SimpleShader::ViewId id );

    //---------------------------------------------------------------------------
    //! @brief  プレビューをリセットします。
    //---------------------------------------------------------------------------
    void ResetPreview( bool bFade );

    //---------------------------------------------------------------------------
    //! @brief  マトリクスを取得します。
    //---------------------------------------------------------------------------
    void GetMatrix( nw::math::MTX34* matrix, s32 idx ) ;

    //---------------------------------------------------------------------------
    //! @brief  ボーン情報バッファを生成します。
    //---------------------------------------------------------------------------
    void DumpBones();

private:
    void*                           mModelBinary;
    nw::eftdemo::SimpleModel        mModel;
    nw::ut::IAllocator*             mNwAllocator;
    void*                           mpModelDataMessage;
    size_t                          mpModelDataMessageSize;

    f32                             mAnimFrame;   //!< アニメーションフレーム
};
