﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace Nintendo.McsServer.McsUtil
{
    using System;
    using System.IO;
    using System.Net;

    /// <summary>
    /// 現時点では、全てのメソッドをoverrideしていないことに注意してください。
    /// </summary>
    public class NetBinaryWriter : BinaryWriter
    {
        public NetBinaryWriter(Stream stream)
            : base(stream)
        {
        }

        public override void Write(char val)
        {
            ushort shortVal = val;
            this.Write(shortVal);
        }

        public override void Write(short val)
        {
            base.Write(IPAddress.HostToNetworkOrder(val));
        }

        public override void Write(ushort val)
        {
            base.Write((ushort)IPAddress.HostToNetworkOrder((short)val));
        }

        public override void Write(int val)
        {
            base.Write(IPAddress.HostToNetworkOrder(val));
        }

        public override void Write(uint val)
        {
            base.Write((uint)IPAddress.HostToNetworkOrder((int)val));
        }

        public override void Write(long val)
        {
            base.Write(IPAddress.HostToNetworkOrder(val));
        }

        public override void Write(ulong val)
        {
            base.Write((ulong)IPAddress.HostToNetworkOrder((long)val));
        }
    }
}
