﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace Nintendo.McsServer
{
    /// <summary>
    /// OptionDialog の概要の説明です。
    /// </summary>
    public class OptionDialog : System.Windows.Forms.Form
    {
        UserSettings _userSettings;

        /// <summary>
        /// ユーザセッティングの内容をコントロールへ反映している間は、
        /// イベントハンドラによってコントロールの状態を変化させないようにします。
        /// </summary>
        bool _applyingUserSettings = false;

        private TabControl tabControl1;
        private TabPage tabPageConnectDevice;
        private TabPage tabPageServerSetting;
        private TabPage tabPageHID;
        private System.Windows.Forms.Label label1;
        private System.Windows.Forms.Button buttonOK;
        private System.Windows.Forms.Button buttonCancel;
        private System.Windows.Forms.NumericUpDown numericUpDownPortNo;
        private System.Windows.Forms.Label label2;
        private System.Windows.Forms.Label label3;
        private System.Windows.Forms.Label label4;
        private System.Windows.Forms.Label label5;
        private System.Windows.Forms.NumericUpDown numericUpDownPollingInterval;
        private System.Windows.Forms.Button buttonSetDefaultValue2;
        private CheckBox cbConnectDeviceCATDEV;
        private CheckBox cbConnectDeviceUSBAdapter;
        private Label label6;
        private Label label7;
        private CheckBox cbCaptureOnMousePosition;
        private CheckBox cbCaptureOnShortcut;
        private CheckBox cbCaptureOnUpperLeft;
        private RadioButton rbCaptureOnPauseKey;
        private RadioButton rbCaptureOnScrollLockKey;
        private Label label8;
        private Panel panelCaptureOnMousePosition;
        private CheckBox cbCaptureOnBottom;
        private CheckBox cbCaptureOnRight;
        private CheckBox cbCaptureOnLeft;
        private CheckBox cbCaptureOnTop;
        private CheckBox cbCaptureOnDownRight;
        private CheckBox cbCaptureOnDownLeft;
        private CheckBox cbCaptureOnUpperRight;
        private ComboBox comboCaptureOnMousePositionCount;
        private Label label9;
        private Label label10;
        private Label label11;
        private RadioButton rbCaptureOnCtrlKey;
        private Label label12;
        private ComboBox comboCaptureOnShortcutInterval;
        private Label label13;
        private TabPage tabPageCheckAlive;
        private Label label15;
        private CheckBox cbCheckAlive;
        private Panel panelCheckAlive;
        private Label label14;
        private NumericUpDown numericUpDownCheckAliveTimeout;
        private Label label16;
        private Label label17;
        private Button buttonSetDefaultValue;
        private Button buttonSetDefaultValue3;
        private Button buttonSetDefaultValue4;
        /// <summary>
        /// 必要なデザイナ変数です。
        /// </summary>
        private System.ComponentModel.Container components = null;

        public OptionDialog(UserSettings userSettings)
        {
            //
            // Windows フォーム デザイナ サポートに必要です。
            //
            InitializeComponent();

            Icon = MainForm.GetApplicationIcon();   // フォームのアイコン設定
            _userSettings = userSettings;
        }

        /// <summary>
        /// 使用されているリソースに後処理を実行します。
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            if( disposing )
            {
                if(components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

        #region Windows フォーム デザイナで生成されたコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(OptionDialog));
            this.tabControl1 = new System.Windows.Forms.TabControl();
            this.tabPageConnectDevice = new System.Windows.Forms.TabPage();
            this.cbConnectDeviceCATDEV = new System.Windows.Forms.CheckBox();
            this.cbConnectDeviceUSBAdapter = new System.Windows.Forms.CheckBox();
            this.label6 = new System.Windows.Forms.Label();
            this.buttonSetDefaultValue2 = new System.Windows.Forms.Button();
            this.tabPageServerSetting = new System.Windows.Forms.TabPage();
            this.buttonSetDefaultValue = new System.Windows.Forms.Button();
            this.numericUpDownPortNo = new System.Windows.Forms.NumericUpDown();
            this.numericUpDownPollingInterval = new System.Windows.Forms.NumericUpDown();
            this.label7 = new System.Windows.Forms.Label();
            this.label1 = new System.Windows.Forms.Label();
            this.label5 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.label4 = new System.Windows.Forms.Label();
            this.label3 = new System.Windows.Forms.Label();
            this.tabPageCheckAlive = new System.Windows.Forms.TabPage();
            this.buttonSetDefaultValue3 = new System.Windows.Forms.Button();
            this.cbCheckAlive = new System.Windows.Forms.CheckBox();
            this.panelCheckAlive = new System.Windows.Forms.Panel();
            this.numericUpDownCheckAliveTimeout = new System.Windows.Forms.NumericUpDown();
            this.label17 = new System.Windows.Forms.Label();
            this.label14 = new System.Windows.Forms.Label();
            this.label16 = new System.Windows.Forms.Label();
            this.label15 = new System.Windows.Forms.Label();
            this.tabPageHID = new System.Windows.Forms.TabPage();
            this.buttonSetDefaultValue4 = new System.Windows.Forms.Button();
            this.label13 = new System.Windows.Forms.Label();
            this.rbCaptureOnCtrlKey = new System.Windows.Forms.RadioButton();
            this.comboCaptureOnShortcutInterval = new System.Windows.Forms.ComboBox();
            this.rbCaptureOnPauseKey = new System.Windows.Forms.RadioButton();
            this.rbCaptureOnScrollLockKey = new System.Windows.Forms.RadioButton();
            this.cbCaptureOnMousePosition = new System.Windows.Forms.CheckBox();
            this.cbCaptureOnShortcut = new System.Windows.Forms.CheckBox();
            this.label12 = new System.Windows.Forms.Label();
            this.label11 = new System.Windows.Forms.Label();
            this.panelCaptureOnMousePosition = new System.Windows.Forms.Panel();
            this.cbCaptureOnUpperLeft = new System.Windows.Forms.CheckBox();
            this.label9 = new System.Windows.Forms.Label();
            this.label8 = new System.Windows.Forms.Label();
            this.cbCaptureOnBottom = new System.Windows.Forms.CheckBox();
            this.cbCaptureOnRight = new System.Windows.Forms.CheckBox();
            this.cbCaptureOnLeft = new System.Windows.Forms.CheckBox();
            this.cbCaptureOnTop = new System.Windows.Forms.CheckBox();
            this.label10 = new System.Windows.Forms.Label();
            this.comboCaptureOnMousePositionCount = new System.Windows.Forms.ComboBox();
            this.cbCaptureOnDownRight = new System.Windows.Forms.CheckBox();
            this.cbCaptureOnDownLeft = new System.Windows.Forms.CheckBox();
            this.cbCaptureOnUpperRight = new System.Windows.Forms.CheckBox();
            this.buttonOK = new System.Windows.Forms.Button();
            this.buttonCancel = new System.Windows.Forms.Button();
            this.tabControl1.SuspendLayout();
            this.tabPageConnectDevice.SuspendLayout();
            this.tabPageServerSetting.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.numericUpDownPortNo)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.numericUpDownPollingInterval)).BeginInit();
            this.tabPageCheckAlive.SuspendLayout();
            this.panelCheckAlive.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.numericUpDownCheckAliveTimeout)).BeginInit();
            this.tabPageHID.SuspendLayout();
            this.panelCaptureOnMousePosition.SuspendLayout();
            this.SuspendLayout();
            //
            // tabControl1
            //
            resources.ApplyResources(this.tabControl1, "tabControl1");
            this.tabControl1.Controls.Add(this.tabPageConnectDevice);
            this.tabControl1.Controls.Add(this.tabPageServerSetting);
            this.tabControl1.Controls.Add(this.tabPageCheckAlive);
            this.tabControl1.Controls.Add(this.tabPageHID);
            this.tabControl1.Name = "tabControl1";
            this.tabControl1.SelectedIndex = 0;
            //
            // tabPageConnectDevice
            //
            this.tabPageConnectDevice.Controls.Add(this.cbConnectDeviceCATDEV);
            this.tabPageConnectDevice.Controls.Add(this.cbConnectDeviceUSBAdapter);
            this.tabPageConnectDevice.Controls.Add(this.label6);
            this.tabPageConnectDevice.Controls.Add(this.buttonSetDefaultValue2);
            resources.ApplyResources(this.tabPageConnectDevice, "tabPageConnectDevice");
            this.tabPageConnectDevice.Name = "tabPageConnectDevice";
            this.tabPageConnectDevice.UseVisualStyleBackColor = true;
            //
            // cbConnectDeviceCATDEV
            //
            resources.ApplyResources(this.cbConnectDeviceCATDEV, "cbConnectDeviceCATDEV");
            this.cbConnectDeviceCATDEV.Name = "cbConnectDeviceCATDEV";
            this.cbConnectDeviceCATDEV.UseVisualStyleBackColor = true;
            //
            // cbConnectDeviceUSBAdapter
            //
            resources.ApplyResources(this.cbConnectDeviceUSBAdapter, "cbConnectDeviceUSBAdapter");
            this.cbConnectDeviceUSBAdapter.Name = "cbConnectDeviceUSBAdapter";
            this.cbConnectDeviceUSBAdapter.UseVisualStyleBackColor = true;
            //
            // label6
            //
            resources.ApplyResources(this.label6, "label6");
            this.label6.Name = "label6";
            //
            // buttonSetDefaultValue2
            //
            resources.ApplyResources(this.buttonSetDefaultValue2, "buttonSetDefaultValue2");
            this.buttonSetDefaultValue2.Name = "buttonSetDefaultValue2";
            this.buttonSetDefaultValue2.Click += new System.EventHandler(this.buttonSetDefaultValue_Click);
            //
            // tabPageServerSetting
            //
            this.tabPageServerSetting.Controls.Add(this.buttonSetDefaultValue);
            this.tabPageServerSetting.Controls.Add(this.numericUpDownPortNo);
            this.tabPageServerSetting.Controls.Add(this.numericUpDownPollingInterval);
            this.tabPageServerSetting.Controls.Add(this.label7);
            this.tabPageServerSetting.Controls.Add(this.label1);
            this.tabPageServerSetting.Controls.Add(this.label5);
            this.tabPageServerSetting.Controls.Add(this.label2);
            this.tabPageServerSetting.Controls.Add(this.label4);
            this.tabPageServerSetting.Controls.Add(this.label3);
            resources.ApplyResources(this.tabPageServerSetting, "tabPageServerSetting");
            this.tabPageServerSetting.Name = "tabPageServerSetting";
            this.tabPageServerSetting.UseVisualStyleBackColor = true;
            //
            // buttonSetDefaultValue
            //
            resources.ApplyResources(this.buttonSetDefaultValue, "buttonSetDefaultValue");
            this.buttonSetDefaultValue.Name = "buttonSetDefaultValue";
            this.buttonSetDefaultValue.Click += new System.EventHandler(this.buttonSetDefaultValue_Click);
            //
            // numericUpDownPortNo
            //
            resources.ApplyResources(this.numericUpDownPortNo, "numericUpDownPortNo");
            this.numericUpDownPortNo.Maximum = new decimal(new int[] {
            65535,
            0,
            0,
            0});
            this.numericUpDownPortNo.Name = "numericUpDownPortNo";
            //
            // numericUpDownPollingInterval
            //
            resources.ApplyResources(this.numericUpDownPollingInterval, "numericUpDownPollingInterval");
            this.numericUpDownPollingInterval.Maximum = new decimal(new int[] {
            500,
            0,
            0,
            0});
            this.numericUpDownPollingInterval.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.numericUpDownPollingInterval.Name = "numericUpDownPollingInterval";
            this.numericUpDownPollingInterval.Value = new decimal(new int[] {
            100,
            0,
            0,
            0});
            //
            // label7
            //
            resources.ApplyResources(this.label7, "label7");
            this.label7.Name = "label7";
            //
            // label1
            //
            resources.ApplyResources(this.label1, "label1");
            this.label1.Name = "label1";
            //
            // label5
            //
            resources.ApplyResources(this.label5, "label5");
            this.label5.Name = "label5";
            //
            // label2
            //
            resources.ApplyResources(this.label2, "label2");
            this.label2.Name = "label2";
            //
            // label4
            //
            resources.ApplyResources(this.label4, "label4");
            this.label4.Name = "label4";
            //
            // label3
            //
            resources.ApplyResources(this.label3, "label3");
            this.label3.Name = "label3";
            //
            // tabPageCheckAlive
            //
            this.tabPageCheckAlive.Controls.Add(this.buttonSetDefaultValue3);
            this.tabPageCheckAlive.Controls.Add(this.cbCheckAlive);
            this.tabPageCheckAlive.Controls.Add(this.panelCheckAlive);
            this.tabPageCheckAlive.Controls.Add(this.label16);
            this.tabPageCheckAlive.Controls.Add(this.label15);
            resources.ApplyResources(this.tabPageCheckAlive, "tabPageCheckAlive");
            this.tabPageCheckAlive.Name = "tabPageCheckAlive";
            this.tabPageCheckAlive.UseVisualStyleBackColor = true;
            //
            // buttonSetDefaultValue3
            //
            resources.ApplyResources(this.buttonSetDefaultValue3, "buttonSetDefaultValue3");
            this.buttonSetDefaultValue3.Name = "buttonSetDefaultValue3";
            this.buttonSetDefaultValue3.Click += new System.EventHandler(this.buttonSetDefaultValue_Click);
            //
            // cbCheckAlive
            //
            resources.ApplyResources(this.cbCheckAlive, "cbCheckAlive");
            this.cbCheckAlive.Name = "cbCheckAlive";
            this.cbCheckAlive.UseVisualStyleBackColor = true;
            this.cbCheckAlive.CheckedChanged += new System.EventHandler(this.cbCheckAlive_CheckedChanged);
            //
            // panelCheckAlive
            //
            resources.ApplyResources(this.panelCheckAlive, "panelCheckAlive");
            this.panelCheckAlive.Controls.Add(this.numericUpDownCheckAliveTimeout);
            this.panelCheckAlive.Controls.Add(this.label17);
            this.panelCheckAlive.Controls.Add(this.label14);
            this.panelCheckAlive.Name = "panelCheckAlive";
            //
            // numericUpDownCheckAliveTimeout
            //
            resources.ApplyResources(this.numericUpDownCheckAliveTimeout, "numericUpDownCheckAliveTimeout");
            this.numericUpDownCheckAliveTimeout.Maximum = new decimal(new int[] {
            500,
            0,
            0,
            0});
            this.numericUpDownCheckAliveTimeout.Minimum = new decimal(new int[] {
            1,
            0,
            0,
            0});
            this.numericUpDownCheckAliveTimeout.Name = "numericUpDownCheckAliveTimeout";
            this.numericUpDownCheckAliveTimeout.Value = new decimal(new int[] {
            100,
            0,
            0,
            0});
            //
            // label17
            //
            resources.ApplyResources(this.label17, "label17");
            this.label17.Name = "label17";
            //
            // label14
            //
            resources.ApplyResources(this.label14, "label14");
            this.label14.Name = "label14";
            //
            // label16
            //
            resources.ApplyResources(this.label16, "label16");
            this.label16.Name = "label16";
            //
            // label15
            //
            resources.ApplyResources(this.label15, "label15");
            this.label15.Name = "label15";
            //
            // tabPageHID
            //
            this.tabPageHID.Controls.Add(this.buttonSetDefaultValue4);
            this.tabPageHID.Controls.Add(this.label13);
            this.tabPageHID.Controls.Add(this.rbCaptureOnCtrlKey);
            this.tabPageHID.Controls.Add(this.comboCaptureOnShortcutInterval);
            this.tabPageHID.Controls.Add(this.rbCaptureOnPauseKey);
            this.tabPageHID.Controls.Add(this.rbCaptureOnScrollLockKey);
            this.tabPageHID.Controls.Add(this.cbCaptureOnMousePosition);
            this.tabPageHID.Controls.Add(this.cbCaptureOnShortcut);
            this.tabPageHID.Controls.Add(this.label12);
            this.tabPageHID.Controls.Add(this.label11);
            this.tabPageHID.Controls.Add(this.panelCaptureOnMousePosition);
            resources.ApplyResources(this.tabPageHID, "tabPageHID");
            this.tabPageHID.Name = "tabPageHID";
            this.tabPageHID.UseVisualStyleBackColor = true;
            //
            // buttonSetDefaultValue4
            //
            resources.ApplyResources(this.buttonSetDefaultValue4, "buttonSetDefaultValue4");
            this.buttonSetDefaultValue4.Name = "buttonSetDefaultValue4";
            this.buttonSetDefaultValue4.Click += new System.EventHandler(this.buttonSetDefaultValue_Click);
            //
            // label13
            //
            resources.ApplyResources(this.label13, "label13");
            this.label13.Name = "label13";
            //
            // rbCaptureOnCtrlKey
            //
            resources.ApplyResources(this.rbCaptureOnCtrlKey, "rbCaptureOnCtrlKey");
            this.rbCaptureOnCtrlKey.Name = "rbCaptureOnCtrlKey";
            this.rbCaptureOnCtrlKey.TabStop = true;
            this.rbCaptureOnCtrlKey.UseVisualStyleBackColor = true;
            //
            // comboCaptureOnShortcutInterval
            //
            this.comboCaptureOnShortcutInterval.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboCaptureOnShortcutInterval.FormattingEnabled = true;
            this.comboCaptureOnShortcutInterval.Items.AddRange(new object[] {
            resources.GetString("comboCaptureOnShortcutInterval.Items"),
            resources.GetString("comboCaptureOnShortcutInterval.Items1"),
            resources.GetString("comboCaptureOnShortcutInterval.Items2"),
            resources.GetString("comboCaptureOnShortcutInterval.Items3"),
            resources.GetString("comboCaptureOnShortcutInterval.Items4"),
            resources.GetString("comboCaptureOnShortcutInterval.Items5"),
            resources.GetString("comboCaptureOnShortcutInterval.Items6"),
            resources.GetString("comboCaptureOnShortcutInterval.Items7"),
            resources.GetString("comboCaptureOnShortcutInterval.Items8"),
            resources.GetString("comboCaptureOnShortcutInterval.Items9"),
            resources.GetString("comboCaptureOnShortcutInterval.Items10"),
            resources.GetString("comboCaptureOnShortcutInterval.Items11"),
            resources.GetString("comboCaptureOnShortcutInterval.Items12"),
            resources.GetString("comboCaptureOnShortcutInterval.Items13"),
            resources.GetString("comboCaptureOnShortcutInterval.Items14"),
            resources.GetString("comboCaptureOnShortcutInterval.Items15"),
            resources.GetString("comboCaptureOnShortcutInterval.Items16"),
            resources.GetString("comboCaptureOnShortcutInterval.Items17"),
            resources.GetString("comboCaptureOnShortcutInterval.Items18"),
            resources.GetString("comboCaptureOnShortcutInterval.Items19"),
            resources.GetString("comboCaptureOnShortcutInterval.Items20")});
            resources.ApplyResources(this.comboCaptureOnShortcutInterval, "comboCaptureOnShortcutInterval");
            this.comboCaptureOnShortcutInterval.Name = "comboCaptureOnShortcutInterval";
            //
            // rbCaptureOnPauseKey
            //
            resources.ApplyResources(this.rbCaptureOnPauseKey, "rbCaptureOnPauseKey");
            this.rbCaptureOnPauseKey.Name = "rbCaptureOnPauseKey";
            this.rbCaptureOnPauseKey.TabStop = true;
            this.rbCaptureOnPauseKey.UseVisualStyleBackColor = true;
            //
            // rbCaptureOnScrollLockKey
            //
            resources.ApplyResources(this.rbCaptureOnScrollLockKey, "rbCaptureOnScrollLockKey");
            this.rbCaptureOnScrollLockKey.Name = "rbCaptureOnScrollLockKey";
            this.rbCaptureOnScrollLockKey.TabStop = true;
            this.rbCaptureOnScrollLockKey.UseVisualStyleBackColor = true;
            //
            // cbCaptureOnMousePosition
            //
            resources.ApplyResources(this.cbCaptureOnMousePosition, "cbCaptureOnMousePosition");
            this.cbCaptureOnMousePosition.Name = "cbCaptureOnMousePosition";
            this.cbCaptureOnMousePosition.UseVisualStyleBackColor = true;
            this.cbCaptureOnMousePosition.CheckedChanged += new System.EventHandler(this.cbCaptureOnMousePosition_CheckedChanged);
            //
            // cbCaptureOnShortcut
            //
            resources.ApplyResources(this.cbCaptureOnShortcut, "cbCaptureOnShortcut");
            this.cbCaptureOnShortcut.Name = "cbCaptureOnShortcut";
            this.cbCaptureOnShortcut.UseVisualStyleBackColor = true;
            this.cbCaptureOnShortcut.CheckedChanged += new System.EventHandler(this.cbCaptureOnShortcut_CheckedChanged);
            //
            // label12
            //
            resources.ApplyResources(this.label12, "label12");
            this.label12.Name = "label12";
            //
            // label11
            //
            resources.ApplyResources(this.label11, "label11");
            this.label11.Name = "label11";
            //
            // panelCaptureOnMousePosition
            //
            resources.ApplyResources(this.panelCaptureOnMousePosition, "panelCaptureOnMousePosition");
            this.panelCaptureOnMousePosition.Controls.Add(this.cbCaptureOnUpperLeft);
            this.panelCaptureOnMousePosition.Controls.Add(this.label9);
            this.panelCaptureOnMousePosition.Controls.Add(this.label8);
            this.panelCaptureOnMousePosition.Controls.Add(this.cbCaptureOnBottom);
            this.panelCaptureOnMousePosition.Controls.Add(this.cbCaptureOnRight);
            this.panelCaptureOnMousePosition.Controls.Add(this.cbCaptureOnLeft);
            this.panelCaptureOnMousePosition.Controls.Add(this.cbCaptureOnTop);
            this.panelCaptureOnMousePosition.Controls.Add(this.label10);
            this.panelCaptureOnMousePosition.Controls.Add(this.comboCaptureOnMousePositionCount);
            this.panelCaptureOnMousePosition.Controls.Add(this.cbCaptureOnDownRight);
            this.panelCaptureOnMousePosition.Controls.Add(this.cbCaptureOnDownLeft);
            this.panelCaptureOnMousePosition.Controls.Add(this.cbCaptureOnUpperRight);
            this.panelCaptureOnMousePosition.Name = "panelCaptureOnMousePosition";
            //
            // cbCaptureOnUpperLeft
            //
            resources.ApplyResources(this.cbCaptureOnUpperLeft, "cbCaptureOnUpperLeft");
            this.cbCaptureOnUpperLeft.Name = "cbCaptureOnUpperLeft";
            this.cbCaptureOnUpperLeft.UseVisualStyleBackColor = true;
            //
            // label9
            //
            resources.ApplyResources(this.label9, "label9");
            this.label9.Name = "label9";
            //
            // label8
            //
            resources.ApplyResources(this.label8, "label8");
            this.label8.Name = "label8";
            //
            // cbCaptureOnBottom
            //
            resources.ApplyResources(this.cbCaptureOnBottom, "cbCaptureOnBottom");
            this.cbCaptureOnBottom.Name = "cbCaptureOnBottom";
            this.cbCaptureOnBottom.UseVisualStyleBackColor = true;
            this.cbCaptureOnBottom.CheckedChanged += new System.EventHandler(this.cbCaptureOnBottom_CheckedChanged);
            //
            // cbCaptureOnRight
            //
            resources.ApplyResources(this.cbCaptureOnRight, "cbCaptureOnRight");
            this.cbCaptureOnRight.Name = "cbCaptureOnRight";
            this.cbCaptureOnRight.UseVisualStyleBackColor = true;
            this.cbCaptureOnRight.CheckedChanged += new System.EventHandler(this.cbCaptureOnRight_CheckedChanged);
            //
            // cbCaptureOnLeft
            //
            resources.ApplyResources(this.cbCaptureOnLeft, "cbCaptureOnLeft");
            this.cbCaptureOnLeft.Name = "cbCaptureOnLeft";
            this.cbCaptureOnLeft.UseVisualStyleBackColor = true;
            this.cbCaptureOnLeft.CheckedChanged += new System.EventHandler(this.cbCaptureOnLeft_CheckedChanged);
            //
            // cbCaptureOnTop
            //
            resources.ApplyResources(this.cbCaptureOnTop, "cbCaptureOnTop");
            this.cbCaptureOnTop.Name = "cbCaptureOnTop";
            this.cbCaptureOnTop.UseVisualStyleBackColor = true;
            this.cbCaptureOnTop.CheckedChanged += new System.EventHandler(this.cbCaptureOnTop_CheckedChanged);
            //
            // label10
            //
            resources.ApplyResources(this.label10, "label10");
            this.label10.Name = "label10";
            //
            // comboCaptureOnMousePositionCount
            //
            this.comboCaptureOnMousePositionCount.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboCaptureOnMousePositionCount.FormattingEnabled = true;
            this.comboCaptureOnMousePositionCount.Items.AddRange(new object[] {
            resources.GetString("comboCaptureOnMousePositionCount.Items"),
            resources.GetString("comboCaptureOnMousePositionCount.Items1"),
            resources.GetString("comboCaptureOnMousePositionCount.Items2"),
            resources.GetString("comboCaptureOnMousePositionCount.Items3"),
            resources.GetString("comboCaptureOnMousePositionCount.Items4"),
            resources.GetString("comboCaptureOnMousePositionCount.Items5"),
            resources.GetString("comboCaptureOnMousePositionCount.Items6"),
            resources.GetString("comboCaptureOnMousePositionCount.Items7"),
            resources.GetString("comboCaptureOnMousePositionCount.Items8"),
            resources.GetString("comboCaptureOnMousePositionCount.Items9"),
            resources.GetString("comboCaptureOnMousePositionCount.Items10"),
            resources.GetString("comboCaptureOnMousePositionCount.Items11"),
            resources.GetString("comboCaptureOnMousePositionCount.Items12"),
            resources.GetString("comboCaptureOnMousePositionCount.Items13"),
            resources.GetString("comboCaptureOnMousePositionCount.Items14"),
            resources.GetString("comboCaptureOnMousePositionCount.Items15"),
            resources.GetString("comboCaptureOnMousePositionCount.Items16"),
            resources.GetString("comboCaptureOnMousePositionCount.Items17"),
            resources.GetString("comboCaptureOnMousePositionCount.Items18"),
            resources.GetString("comboCaptureOnMousePositionCount.Items19"),
            resources.GetString("comboCaptureOnMousePositionCount.Items20")});
            resources.ApplyResources(this.comboCaptureOnMousePositionCount, "comboCaptureOnMousePositionCount");
            this.comboCaptureOnMousePositionCount.Name = "comboCaptureOnMousePositionCount";
            //
            // cbCaptureOnDownRight
            //
            resources.ApplyResources(this.cbCaptureOnDownRight, "cbCaptureOnDownRight");
            this.cbCaptureOnDownRight.Name = "cbCaptureOnDownRight";
            this.cbCaptureOnDownRight.UseVisualStyleBackColor = true;
            //
            // cbCaptureOnDownLeft
            //
            resources.ApplyResources(this.cbCaptureOnDownLeft, "cbCaptureOnDownLeft");
            this.cbCaptureOnDownLeft.Name = "cbCaptureOnDownLeft";
            this.cbCaptureOnDownLeft.UseVisualStyleBackColor = true;
            //
            // cbCaptureOnUpperRight
            //
            resources.ApplyResources(this.cbCaptureOnUpperRight, "cbCaptureOnUpperRight");
            this.cbCaptureOnUpperRight.Name = "cbCaptureOnUpperRight";
            this.cbCaptureOnUpperRight.UseVisualStyleBackColor = true;
            //
            // buttonOK
            //
            resources.ApplyResources(this.buttonOK, "buttonOK");
            this.buttonOK.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.buttonOK.Name = "buttonOK";
            //
            // buttonCancel
            //
            resources.ApplyResources(this.buttonCancel, "buttonCancel");
            this.buttonCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.buttonCancel.Name = "buttonCancel";
            //
            // OptionDialog
            //
            this.AcceptButton = this.buttonOK;
            resources.ApplyResources(this, "$this");
            this.CancelButton = this.buttonCancel;
            this.Controls.Add(this.tabControl1);
            this.Controls.Add(this.buttonCancel);
            this.Controls.Add(this.buttonOK);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "OptionDialog";
            this.ShowInTaskbar = false;
            this.Load += new System.EventHandler(this.OptionDialog_Load);
            this.Closed += new System.EventHandler(this.OptionDialog_Closed);
            this.tabControl1.ResumeLayout(false);
            this.tabPageConnectDevice.ResumeLayout(false);
            this.tabPageConnectDevice.PerformLayout();
            this.tabPageServerSetting.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.numericUpDownPortNo)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.numericUpDownPollingInterval)).EndInit();
            this.tabPageCheckAlive.ResumeLayout(false);
            this.tabPageCheckAlive.PerformLayout();
            this.panelCheckAlive.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.numericUpDownCheckAliveTimeout)).EndInit();
            this.tabPageHID.ResumeLayout(false);
            this.tabPageHID.PerformLayout();
            this.panelCaptureOnMousePosition.ResumeLayout(false);
            this.panelCaptureOnMousePosition.PerformLayout();
            this.ResumeLayout(false);

        }
        #endregion

        private void ApplayUserSetting_ServerSetting(UserSettings userSetting)
        {
            _applyingUserSettings = true;

            numericUpDownPortNo.Value = userSetting.PortNo;
            numericUpDownPollingInterval.Value = userSetting.PollingInterval;

            _applyingUserSettings = false;
        }

        private void ApplayUserSetting_ConnectDevice(UserSettings userSetting)
        {
            _applyingUserSettings = true;

            cbConnectDeviceUSBAdapter.Checked = !userSetting.DisableDeviceUSBAdapter;
            cbConnectDeviceCATDEV.Checked = !userSetting.DisableDeviceCATDEV;

            _applyingUserSettings = false;
        }

        private void ApplayUserSetting_HID(UserSettings userSetting)
        {
            _applyingUserSettings = true;

            cbCaptureOnShortcut.Checked = userSetting.IsCaptureOnKeyShortcut;
            cbCaptureOnMousePosition.Checked = userSetting.IsCaptureOnMousePosition;

            if (userSetting.CaptureShortcutKey == Keys.Scroll)
            {
                rbCaptureOnScrollLockKey.Checked = true;
                rbCaptureOnPauseKey.Checked = false;
                rbCaptureOnCtrlKey.Checked = false;
            }
            else if (userSetting.CaptureShortcutKey == Keys.Pause)
            {
                rbCaptureOnScrollLockKey.Checked = false;
                rbCaptureOnPauseKey.Checked = true;
                rbCaptureOnCtrlKey.Checked = false;
            }
            else
            {
                rbCaptureOnScrollLockKey.Checked = false;
                rbCaptureOnPauseKey.Checked = false;
                rbCaptureOnCtrlKey.Checked = true;
            }

            cbCaptureOnUpperLeft.Checked = (userSetting.CaptureMousePosition & UserSettings.CapturePosition.UpperLeft) != 0;
            cbCaptureOnUpperRight.Checked = (userSetting.CaptureMousePosition & UserSettings.CapturePosition.UpperRight) != 0;
            cbCaptureOnDownLeft.Checked = (userSetting.CaptureMousePosition & UserSettings.CapturePosition.DownLeft) != 0;
            cbCaptureOnDownRight.Checked = (userSetting.CaptureMousePosition & UserSettings.CapturePosition.DownRight) != 0;
            cbCaptureOnTop.Checked = (userSetting.CaptureMousePosition & UserSettings.CapturePosition.Top) != 0;
            cbCaptureOnBottom.Checked = (userSetting.CaptureMousePosition & UserSettings.CapturePosition.Bottom) != 0;
            cbCaptureOnLeft.Checked = (userSetting.CaptureMousePosition & UserSettings.CapturePosition.Left) != 0;
            cbCaptureOnRight.Checked = (userSetting.CaptureMousePosition & UserSettings.CapturePosition.Right) != 0;

            {
                int mouseShortcutTime = (int)userSetting.CaptureOnMousePositionCount;
                int MaxTime = comboCaptureOnMousePositionCount.Items.Count * 100;
                int Span = 100;

                mouseShortcutTime = Math.Max(mouseShortcutTime, 0);
                mouseShortcutTime = Math.Min(mouseShortcutTime, MaxTime);

                comboCaptureOnMousePositionCount.SelectedIndex = mouseShortcutTime / Span;
            }

            {
                int shortcutInterval = (int)userSetting.CaptureOnKeyShortcutInterval;
                int MaxTime = comboCaptureOnShortcutInterval.Items.Count * 100;
                int Span = 100;

                shortcutInterval = Math.Max(shortcutInterval, 0);
                shortcutInterval = Math.Min(shortcutInterval, MaxTime);

                comboCaptureOnShortcutInterval.SelectedIndex = shortcutInterval / Span;
            }

            _applyingUserSettings = false;
        }

        private void ApplayUserSetting_CheckAlive(UserSettings userSetting)
        {
            _applyingUserSettings = true;

            cbCheckAlive.Checked = userSetting.IsCheckAlive;
            numericUpDownCheckAliveTimeout.Value = userSetting.CheckAliveTimeout;

            _applyingUserSettings = false;
        }

        private void ApplayUserSetting(UserSettings userSetting)
        {
            this.ApplayUserSetting_ConnectDevice(userSetting);
            this.ApplayUserSetting_ServerSetting(userSetting);
            this.ApplayUserSetting_CheckAlive(userSetting);
            this.ApplayUserSetting_HID(userSetting);
        }

        private void OptionDialog_Load(object sender, System.EventArgs e)
        {
            this.ApplayUserSetting(_userSettings);

            this.UpdateEnabledFlag();
        }

        private void OptionDialog_Closed(object sender, System.EventArgs e)
        {
            if (this.DialogResult == DialogResult.OK)
            {
                _userSettings.PortNo = Decimal.ToUInt16(numericUpDownPortNo.Value);
                _userSettings.PollingInterval = Decimal.ToUInt32(numericUpDownPollingInterval.Value);
                _userSettings.DisableDeviceUSBAdapter = !cbConnectDeviceUSBAdapter.Checked;
                _userSettings.DisableDeviceCATDEV = !cbConnectDeviceCATDEV.Checked;

                _userSettings.IsCaptureOnKeyShortcut = cbCaptureOnShortcut.Checked;

                if (rbCaptureOnScrollLockKey.Checked)
                {
                    _userSettings.CaptureShortcutKey = Keys.Scroll;
                }
                else if (rbCaptureOnPauseKey.Checked)
                {
                    _userSettings.CaptureShortcutKey = Keys.Pause;
                }
                else
                {
                    _userSettings.CaptureShortcutKey = Keys.LControlKey;
                }

                _userSettings.IsCaptureOnMousePosition = cbCaptureOnMousePosition.Checked;
                _userSettings.CaptureOnMousePositionCount = comboCaptureOnMousePositionCount.SelectedIndex * 100;
                _userSettings.CaptureOnKeyShortcutInterval = comboCaptureOnShortcutInterval.SelectedIndex * 100;

                UserSettings.CapturePosition capturePosition = UserSettings.CapturePosition.None;

                if (cbCaptureOnUpperLeft.Checked)
                {
                    capturePosition |= UserSettings.CapturePosition.UpperLeft;
                }

                if (cbCaptureOnUpperRight.Checked)
                {
                    capturePosition |= UserSettings.CapturePosition.UpperRight;
                }

                if (cbCaptureOnDownLeft.Checked)
                {
                    capturePosition |= UserSettings.CapturePosition.DownLeft;
                }

                if (cbCaptureOnDownRight.Checked)
                {
                    capturePosition |= UserSettings.CapturePosition.DownRight;
                }

                if (cbCaptureOnTop.Checked)
                {
                    capturePosition |= UserSettings.CapturePosition.Top;
                }

                if (cbCaptureOnBottom.Checked)
                {
                    capturePosition |= UserSettings.CapturePosition.Bottom;
                }

                if (cbCaptureOnLeft.Checked)
                {
                    capturePosition |= UserSettings.CapturePosition.Left;
                }

                if (cbCaptureOnRight.Checked)
                {
                    capturePosition |= UserSettings.CapturePosition.Right;
                }

                _userSettings.CaptureMousePosition = capturePosition;

                _userSettings.IsCheckAlive = cbCheckAlive.Checked;
                _userSettings.CheckAliveTimeout = Decimal.ToUInt16(numericUpDownCheckAliveTimeout.Value);
            }
        }

        /// <summary>
        /// チェックボックスの状態から各コントロールの Enabled 設定を更新します。
        /// </summary>
        private void UpdateEnabledFlag()
        {
            bool captureOnShortcut = cbCaptureOnShortcut.Checked;
            bool captureOnMousePosition = cbCaptureOnMousePosition.Checked;

            rbCaptureOnPauseKey.Enabled = captureOnShortcut;
            rbCaptureOnScrollLockKey.Enabled = captureOnShortcut;
            rbCaptureOnCtrlKey.Enabled = captureOnShortcut;
            comboCaptureOnShortcutInterval.Enabled = captureOnShortcut;
            label12.Enabled = captureOnShortcut;
            label13.Enabled = captureOnShortcut;

            panelCaptureOnMousePosition.Enabled = captureOnMousePosition;
            cbCaptureOnUpperLeft.Enabled = !cbCaptureOnTop.Checked && !cbCaptureOnLeft.Checked;
            cbCaptureOnUpperRight.Enabled = !cbCaptureOnTop.Checked && !cbCaptureOnRight.Checked;
            cbCaptureOnDownLeft.Enabled = !cbCaptureOnBottom.Checked && !cbCaptureOnLeft.Checked;
            cbCaptureOnDownRight.Enabled = !cbCaptureOnBottom.Checked && !cbCaptureOnRight.Checked;

            bool checkAlive = cbCheckAlive.Checked;
            panelCheckAlive.Enabled = checkAlive;
        }

        private void buttonSetDefaultValue_Click(object sender, EventArgs e)
        {
            UserSettings defaultSetting = new UserSettings();

            if (tabControl1.SelectedTab == tabPageConnectDevice)
            {
                this.ApplayUserSetting_ConnectDevice(defaultSetting);
            }

            if (tabControl1.SelectedTab == tabPageServerSetting)
            {
                this.ApplayUserSetting_ServerSetting(defaultSetting);
            }

            if (tabControl1.SelectedTab == tabPageCheckAlive)
            {
                this.ApplayUserSetting_CheckAlive(defaultSetting);
            }

            if (tabControl1.SelectedTab == tabPageHID)
            {
                this.ApplayUserSetting_HID(defaultSetting);
            }

            this.UpdateEnabledFlag();
        }

        /// <summary>
        /// チェックボックスの値が変更になった場合に、各コントロールの Enabled 設定も更新します。
        /// </summary>
        private void cbCaptureOnShortcut_CheckedChanged(object sender, EventArgs e)
        {
            this.UpdateEnabledFlag();
        }

        /// <summary>
        /// チェックボックスの値が変更になった場合に、各コントロールの Enabled 設定も更新します。
        /// </summary>
        private void cbCaptureOnMousePosition_CheckedChanged(object sender, EventArgs e)
        {
            this.UpdateEnabledFlag();
        }

        /// <summary>
        /// チェックボックスの値が変更になった場合に、各コントロールの Enabled 設定も更新します。
        /// </summary>
        private void cbCheckAlive_CheckedChanged(object sender, EventArgs e)
        {
            this.UpdateEnabledFlag();
        }

        private void cbCaptureOnTop_CheckedChanged(object sender, EventArgs e)
        {
            if (!_applyingUserSettings)
            {
                this.cbCaptureOnUpperLeft.Checked = this.cbCaptureOnTop.Checked || this.cbCaptureOnLeft.Checked;
                this.cbCaptureOnUpperRight.Checked = this.cbCaptureOnTop.Checked || this.cbCaptureOnRight.Checked;
                this.UpdateEnabledFlag();
            }
        }

        private void cbCaptureOnBottom_CheckedChanged(object sender, EventArgs e)
        {
            if (!_applyingUserSettings)
            {
                this.cbCaptureOnDownLeft.Checked = this.cbCaptureOnBottom.Checked || this.cbCaptureOnLeft.Checked;
                this.cbCaptureOnDownRight.Checked = this.cbCaptureOnBottom.Checked || this.cbCaptureOnRight.Checked;
                this.UpdateEnabledFlag();
            }
        }

        private void cbCaptureOnLeft_CheckedChanged(object sender, EventArgs e)
        {
            if (!_applyingUserSettings)
            {
                this.cbCaptureOnUpperLeft.Checked = this.cbCaptureOnTop.Checked || this.cbCaptureOnLeft.Checked;
                this.cbCaptureOnDownLeft.Checked = this.cbCaptureOnBottom.Checked || this.cbCaptureOnLeft.Checked;
                this.UpdateEnabledFlag();
            }
        }

        private void cbCaptureOnRight_CheckedChanged(object sender, EventArgs e)
        {
            if (!_applyingUserSettings)
            {
                this.cbCaptureOnUpperRight.Checked = this.cbCaptureOnTop.Checked || this.cbCaptureOnRight.Checked;
                this.cbCaptureOnDownRight.Checked = this.cbCaptureOnBottom.Checked || this.cbCaptureOnRight.Checked;
                this.UpdateEnabledFlag();
            }
        }
    }
}
