﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include <algorithm>
#include <memory>
#include <vector>
#include <autoTestAssistTool/TmUtilityLibrary.h>
#include "..\..\..\..\..\..\..\Externals\Oasis\include\tm.h"

#define RETURN_IF_FAILURE(operation) \
do { \
    nn::tm::Error MACRO_ERROR = operation; \
    if (MACRO_ERROR != nn::tm::Error_Ok) \
    { \
        nn::tm::ErrorText MACRO_ERROR_STRING; \
        nn::tm::GetErrorTextEn(&MACRO_ERROR_STRING, MACRO_ERROR); \
        DEBUG_LOG("%s failed because %s(%d).\n", #operation, MACRO_ERROR_STRING.text, MACRO_ERROR); \
        return TmUtilityResult_ConnectFailed; \
    } \
} while (0)

namespace
{
    const int TmsControlPort = 8003;
}

TmUtilityResult GetConnectedTargetCount(int* pOutCount)
{
    int32_t targetCount;
    RETURN_IF_FAILURE(nn::tm::GetTargetCount(&targetCount));

    std::unique_ptr<nn::tm::TargetHandle[]> pTargetHandles(new nn::tm::TargetHandle[targetCount]);
    RETURN_IF_FAILURE(nn::tm::GetTargets(pTargetHandles.get(), &targetCount, targetCount));

    int connectedTargetCount = 0;
    for (int32_t iTarget = 0; iTarget < targetCount; iTarget++)
    {
        nn::tm::Error error;
        bool isConnected;
        error = nn::tm::GetTargetIsConnected(&isConnected, pTargetHandles[iTarget]);
        if (error == nn::tm::Error_Ok && isConnected)
        {
            connectedTargetCount++;
        }
    }
    (*pOutCount) = connectedTargetCount;
    return TmUtilityResult_Success;
}

TmUtilityResult GetConnectedTargetSerialNumbers(
    SerialNumberString outSerialNumberArray[], int serialNumberArrayCount)
{
    int32_t targetCount;
    RETURN_IF_FAILURE(nn::tm::GetTargetCount(&targetCount));

    std::unique_ptr<nn::tm::TargetHandle[]> pTargetHandles(new nn::tm::TargetHandle[targetCount]);
    RETURN_IF_FAILURE(nn::tm::GetTargets(pTargetHandles.get(), &targetCount, targetCount));

    std::vector<std::string> serialNumbers;

    int connectedTargetCount = 0;
    for (int32_t iTarget = 0; iTarget < targetCount; iTarget++)
    {
        nn::tm::Error error;
        bool isConnected;
        error = nn::tm::GetTargetIsConnected(&isConnected, pTargetHandles[iTarget]);
        if (error == nn::tm::Error_Ok && isConnected)
        {
            nn::tm::TargetSerialNumber serialNumber;
            if (nn::tm::GetTargetSerialNumber(&serialNumber, pTargetHandles[iTarget])
                == nn::tm::Error_Ok)
            {
                serialNumbers.push_back(serialNumber.serialNumber);
            }
        }
    }

    int count = 0;
    for (auto serial : serialNumbers)
    {
        strcpy_s(outSerialNumberArray[count].value,
            sizeof(SerialNumberString::value), serial.c_str());
        count++;
        if (count >= serialNumberArrayCount)
        {
            break;
        }
    }

    return TmUtilityResult_Success;
}
