﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "stdafx.h"
#include <autoTestAssistTool/LogReaderTypes.h>

#include <cstdlib>
#include <deque>
#include <thread>
#include <chrono>

namespace detail
{
    const USHORT TmsControlPort = 8003;

    class LogAccessor
    {
    public:
        LogAccessor();
        ~LogAccessor();

        void ReadFunc();
        LogReaderResult Start(int size, const char* serialNumber);
        void Stop();
        LogReaderResult GetCurrent(std::string *pOutString, int timeoutMs);
        LogReaderResult WaitForNextLine(int timeoutMs);
        std::string GetCurrentTimeString();
        bool IsFirst();
        bool IsLast();
        void MoveToNewestLine();
        LogReaderResult MoveToNextLine();
        LogReaderResult MoveToPreviousLine();
        void MoveToFormerLineByTime(int timeMs);

        int GetLogNum()
        {
            return static_cast<int>(m_LogList.size());
        }

        void PrintFullLog();

    private:
        struct LogData
        {
            std::string log;
            std::chrono::system_clock::time_point time;
        };

        ::SOCKET m_Socket;
        std::thread m_Thread;
        std::deque<LogData> m_LogList;
        int m_Index;
        int m_Size;
    };
}

