﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include "IoPortSender.h"
#include "TouchException.h"



class TouchScreenInputer
{
private:
    IoPortSender*       m_Sender;

    void CheckTouchId(int id);
    void CorrectPositionValue(int &x, int &y);
public:
    explicit TouchScreenInputer(IoPortSender *sender);
    ~TouchScreenInputer();

    void SetTouchState(int touchIdList[], int fingerIdList[], float posXList[], float posYList[], int touchCount);
    void ResetTouchState();

    void PressDown(int touchId, int x, int y);
    void PressDown(int touchId, int x, int y, int fingerId);
    void PressUp(int touchId);
    void MoveTo(int touchId, int, int);
};
