﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <exception>
#include <sstream>

#include "common.h"

class InvalidTouchIdException : public std::exception
{
private:
    unsigned int            m_InvalidTouchId;

public:
    explicit InvalidTouchIdException(unsigned int id) : exception()
    {
        m_InvalidTouchId = id;
    }
    std::string what()
    {
        std::ostringstream outputString;
        outputString << "Invalid touch id was specified. touchId=" << m_InvalidTouchId;
        return outputString.str();
    }
};

class InvalidFingerIdException : public std::exception
{
private:
    unsigned int            m_InvalidFingerId;

public:
    explicit InvalidFingerIdException(unsigned int id) : exception()
    {
        m_InvalidFingerId = id;
    }
    std::string what()
    {
        std::ostringstream outputString;
        outputString << "Invalid finger id was specified. fingerId=" << m_InvalidFingerId;
        return outputString.str();
    }
};
