﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "TouchScreenInputer.h"

class TouchAction
{
private:
    TouchScreenInputer* m_TouchInterface;

public:
    explicit TouchAction(TouchScreenInputer* touchInterface);
    ~TouchAction();

    void SetTouchState(int touchIdList[], int fingerIdList[], float posXList[], float posYList[], int touchCount);

    void TouchPressDown(int touchId, int x, int y);
    void TouchPressDown(int touchId, int x, int y, int fingerId);
    void TouchPressUp(int touchId);
    void TouchMove(int touchId, int x, int y);
    void Tap(int touchId, int x, int y, int waitPress);


    // 動操作
    void DragAngle(int touchId, int startX, int startY, float angle, float length,
        int actionDuration, int waitSpan, bool releaseAfter);

    void DragPos(int touchId, int startX, int startY, int endX, int endY,
        int actionDuration, int waitSpan, bool releaseAfter);
};
