﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "TouchAction.h"


TouchAction::TouchAction(TouchScreenInputer* touchInterface)
{
    m_TouchInterface = touchInterface;
}


TouchAction::~TouchAction()
{
}

void TouchAction::SetTouchState(int touchIdList[], int fingerIdList[], float posXList[], float posYList[], int touchCount)
{
    m_TouchInterface->SetTouchState(touchIdList, fingerIdList, posXList, posYList, touchCount);
}

void TouchAction::TouchPressDown(int touchId, int x, int y)
{
    m_TouchInterface->PressDown(touchId, x, y);
}

void TouchAction::TouchPressDown(int touchId, int x, int y, int fingerId)
{
    m_TouchInterface->PressDown(touchId, x, y, fingerId);
}

void TouchAction::TouchPressUp(int touchId)
{
    m_TouchInterface->PressUp(touchId);
}

void TouchAction::Tap(int touchId, int x, int y, int waitPress)
{
    m_TouchInterface->PressDown(touchId, x, y);
    Sleep(waitPress);
    m_TouchInterface->PressUp(touchId);
}


void TouchAction::TouchMove(int touchId, int x, int y)
{
    m_TouchInterface->MoveTo(touchId, x, y);
}



void TouchAction::DragAngle(int touchId, int startX, int startY, float angle, float length,
    int actionDuration, int waitSpan, bool releaseAfter)
{

    int endX = static_cast<int>(startX + (cos((angle / 180.0) * 3.14) * length));
    int endY = static_cast<int>(startY + (sin((angle / 180.0) * 3.14) * length));

    DragPos(touchId, startX, startY, endX, endY, actionDuration,  waitSpan, releaseAfter);
}



void TouchAction::DragPos(int touchId, int startX, int startY, int endX, int endY,
    int actionDuration,  int waitSpan, bool releaseAfter)
{

    this->TouchPressDown(touchId, startX, startY);

    int diffX = endX - startX;
    int diffY = endY - startY;


    for( int i = actionDuration; i > 0; i -= waitSpan )
    {
        float progress = static_cast<float>(actionDuration -  (i - waitSpan)) / actionDuration;
        if (progress > 1.0f)
        {
            // TIPS: waitSpan が actionDuration の約数で無い場合は、最後の progress が 100 を超えるため、移動量を補正する必要がある。
            progress = 1.0f;
        }

        this->TouchMove(touchId,
            startX + static_cast<int>(diffX * progress),
            startY + static_cast<int>(diffY * progress));

        Sleep( min(waitSpan, i) );
    }

    // タッチ解放
    if (releaseAfter)
    {
        this->TouchPressUp(touchId);
    }
}
