﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <vector>
#include <chrono>
#include <cstdint>
#include "common.h"
#include "HidShellLibraryWrapper.h"

class IoPortRecorder
{
public:
    IoPortRecorder();
    ~IoPortRecorder();

    void StoreHidInput(HidShellHandle handle, uint32_t port, int32_t direction);
    void ClearHidRecord();
    const std::vector<HidTaskRecord>& GetRecords();

private:
    std::vector<HidTaskRecord>    m_TaskList;
    // xpad
    HidShellBasicXpadState  m_NewXpadState[ HidShellBasicXpadCountMax ];
    HidShellBasicXpadState  m_OldXpadState[ HidShellBasicXpadCountMax ];
    // debug pad
    HidShellDebugPadState   m_NewDebugPadState;
    HidShellDebugPadState   m_OldDebugPadState;
    // touch screen
    HidShellTouchScreenState m_OldTouchScreenState;
    HidShellTouchScreenState m_NewTouchScreenState;
    // home button
    HidShellHomeButtonState      m_OldHomeButtonState;
    HidShellHomeButtonState      m_NewHomeButtonState;
    // capture button
    HidShellCaptureButtonState   m_OldCaptureButtonState;
    HidShellCaptureButtonState   m_NewCpatureButtonState;
    // abstracted pad
    HidShellAbstractedPadState m_NewAbstractedPadState[HidShellAbstractedPadCountMax];
    HidShellAbstractedPadState m_OldAbstractedPadState[HidShellAbstractedPadCountMax];

    void SetTask( const std::chrono::system_clock::time_point &time, int32_t id, int32_t value, HidTaskType taskType );
    void StoreAbstractedPadInput(const std::chrono::system_clock::time_point &time, HidShellHandle handle, uint32_t port, int32_t direction);
    void StoreXPadInput( const std::chrono::system_clock::time_point &time, HidShellHandle handle, uint32_t port, int32_t direction);
    void StoreDebugPadInput( const std::chrono::system_clock::time_point &time, HidShellHandle handle, uint32_t port, int32_t direction );
    void StoreTouchScreenInput(const std::chrono::system_clock::time_point &time, HidShellHandle handle, uint32_t port, int32_t direction);
};

