﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

struct BinarizationFilterParam
{
    int threshold;
};
struct ColorRangeFilterParam
{
    Rgb24Color lowerColor;
    Rgb24Color upperColor;
};

struct MorphologyFilterParam
{
    MorphologyConversionType type;
    int iterations;
};

union FilterParam
{
    BinarizationFilterParam binarizationFilterParam;
    ColorRangeFilterParam colorRangeFilterParam;
    MorphologyFilterParam morphologyFilterParam;
};

enum FilterActionType : int32_t
{
    FilterActionType_Binarization,
    FilterActionType_ColorRange,
    FilterActionType_Morphology,
};

struct FilterAction
{
    FilterActionType type;
    FilterParam param;
};

class InvalidFilterIdException
{
public:
    explicit InvalidFilterIdException(FilterIdType filterId)
    {
        m_InvalidFilterId = filterId;
    }

    std::string what()
    {
        std::ostringstream outputString;
        outputString << "Invalid filterId was specified. FilterId=" << m_InvalidFilterId.id;
        return outputString.str();
    }

private:
    FilterIdType    m_InvalidFilterId;
};

class InvalidFilterActionTypeException
{
public:
    explicit InvalidFilterActionTypeException(FilterActionType type)
    {
        m_InvalidFilterActionType = type;
    }

    std::string what()
    {
        std::ostringstream outputString;
        outputString << "Invalid filterActionType was specified. FilterId=" << m_InvalidFilterActionType;
        return outputString.str();
    }

private:
    FilterActionType    m_InvalidFilterActionType;
};

class InvalidFilterParameterException : public std::exception
{
public:
    explicit InvalidFilterParameterException(FilterActionType type)
    {
        m_FilterActionType = type;
    }
    std::string what()
    {
        std::ostringstream outputString;
        outputString << "Invalid filter parameter was specified at FilterActionType=" << static_cast<int>(m_FilterActionType);
        return outputString.str();
    }

private:
    FilterActionType            m_FilterActionType;
};
