﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <autoTestAssistTool\CaptureProcessorTypes.h>
#include <map>
#include <mutex>
#include <opencv2/opencv.hpp>
#include <vector>

#include "FilterOptions.h"

class FilterManager
{
public:
    FilterManager();
    ~FilterManager();

    void CreateFilter(FilterIdType* pOutFilterId);
    void DeleteFilter(FilterIdType filterId);
    void SetBinarizationFilter(FilterIdType filterId, BinarizationFilterParam param);
    void SetColorRangeFilter(FilterIdType filterId, ColorRangeFilterParam param);
    void SetMorphologyFilter(FilterIdType filterId, MorphologyFilterParam param);
    void ApplyFilter(cv::Mat *pOutImage, cv::Mat srcImage, FilterIdType filterId);

private:
    std::map<FilterIdType, std::vector<FilterAction> > m_FilterList;
    std::mutex  m_FilterListMutex;

    void CheckFilterId(FilterIdType filterId);
    void ApplyBinarizationFilter(cv::Mat& dest, const cv::Mat src, BinarizationFilterParam param);
    void ApplyColorRangeFilter(cv::Mat& dest, const cv::Mat src, ColorRangeFilterParam param);
    void ApplyMorphologyFilter(cv::Mat& dest, const cv::Mat src, MorphologyFilterParam param);
};
