﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "common.h"
#include "CaptureProcessorException.h"
#include "ICapture.h"

class DevkitCapture : public ICapture
{
public:
    DevkitCapture(std::string strIp, std::string serialNumber, bool isPreview);
    ~DevkitCapture();

private:
    CaptureResult GetImageDataFromHostBridge(uint8_t* pOutColorBuffer, size_t colorBufferSize, std::string strIp);

    void StartCapture();
    void EndCapture();
    void RunCapture();
    void Capture();

    // ウィンドウ情報
    std::string GetPreviewName();
    int GetOriginalPreviewWidth();
    int GetOriginalPreviewHeight();

    std::string     m_Ip;
    std::string     m_SerialNumber;
    std::unique_ptr<std::thread>    m_CaptureThread;
};
