﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <nn/nn_Result.h>

//--------------------------------------------------------------------------
/**
*   @brief      Xcie ヘッダを Xci に復号化します。
*
*   @param[out]  pOutBuffer                  復号化されたヘッダ
*   @param[in]   outBufferSize               pOutBuffer のサイズ
*   @param[in]   encryptedBuffer             ヘッダ中の暗号化領域
*   @param[in]   encryptedBufferSize         encryptedBuffer のサイズ
*   @param[in]   encryptedKeyIvBuffer        ヘッダ中の暗号化された keyIv
*   @param[in]   encryptedKeyIvBufferSize    encryptedKeyIvBuffer のサイズ
*
*   @return     なし
*/
nn::Result DecryptXcieToXci(char* pOutBuffer, size_t outBufferSize,
                            char* encryptedBuffer, size_t encryptedBufferSize,
                            char* encryptedKeyIvBuffer, size_t encryptedKeyIvBufferSize);
