﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/swkbd/swkbd_Api.h>

#include "ShopMonitoringTool_UiMenuItem.h"

class IntegerItem : public MenuItem
{
public:
    IntegerItem(std::string name, int defaultVal, int maxVal, int minVal);
    std::string GetValueName();
    void* GetValue();
    Scene* CallEnter();
    void CallIncrement();
    void CallDecrement();
private:
    int m_IntegerValue;
    int m_Max;
    int m_Min;
};

class BooleanItem : public MenuItem
{
public:
    BooleanItem(std::string _name, bool defaultVal);
    std::string GetValueName();
    void* GetValue();
    Scene* CallEnter();
private:
    bool m_BooleanValue;
};

class StringItem : public MenuItem
{
public:
    StringItem(std::string _name, std::string defaultVal);
    std::string GetValueName();
    void* GetValue();
    Scene* CallEnter();
private:
    std::string m_StringValue;
};
