﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ShopMonitoringTool_UiProcTimer.h"

ProcTimer::ProcTimer()
{
    m_WaitTime = 0;
}

void ProcTimer::StartWaitTimer(int waitTime)
{
    m_WaitTime = waitTime;
    m_WaitTimerStartTick = nn::os::GetSystemTick();
}

void ProcTimer::StartElapTimer()
{
    m_ElapTimerStartTick = nn::os::GetSystemTick();
}

int ProcTimer::CalcTempRemaingTime()
{
    nn::os::Tick nowTick = nn::os::GetSystemTick();
    auto elapsedTime = (nowTick - m_WaitTimerStartTick).ToTimeSpan().GetMilliSeconds();

    return m_WaitTime * 1000 - elapsedTime;
}

float ProcTimer::GetRemainingTime()
{
    int tempRemainingTime = CalcTempRemaingTime();
    if (tempRemainingTime <= 0)
    {
        return 0.f;
    }
    else
    {
        return tempRemainingTime / 1000.f;
    }
}

float ProcTimer::GetElapsedTime()
{
    nn::os::Tick nowTick = nn::os::GetSystemTick();
    auto elapsedTime = (nowTick - m_WaitTimerStartTick).ToTimeSpan().GetMilliSeconds();

    return elapsedTime / 1000.f;
}

bool ProcTimer::IsRemining()
{
    if (CalcTempRemaingTime() <= 0)
    {
        return false;
    }
    else
    {
        return true;
    }
}
