﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>
#include <cstring>
#include <vector>

#include "ShopMonitoringTool_SysFramework.h"
#include "ShopMonitoringTool_UiScene.h"
#include "ShopMonitoringTool_UiMenuItem.h"

class MenuScene : public Scene
{
public:
    NN_IMPLICIT MenuScene(std::string titleName);
    virtual ~MenuScene();
    void PushItem(MenuItem* pItem);
    void SetupScene();
    std::vector<MenuItem*>& GetItemList();
    virtual void Draw();
    void Update();
    void Control();
    std::string GetDescription();
protected:
    MenuScene* GetPtr();
    MenuItem* GetSelectedItem();
    void NextItem();
    void PrevItem();
    void EnterItem();
protected:
    std::vector<MenuItem*> m_ItemList;
    std::string     m_MenuTitleName;
    int             m_SelectedItemIndex;
};
