﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ShopMonitoringTool_UiLogViewScene.h"

LogScene::~LogScene()
{

}

void LogScene::DisplayRangeUp()
{
    m_DisplayLogLineStartPos = std::max(0, m_DisplayLogLineStartPos - 1);
}
void LogScene::DisplayRangeDown()
{
    int count = gLog.GetCount();
    if (m_DisplayLogLineStartPos + DisplayLogLineSize + 1 > count)
    {
        return;
    }
    else
    {
        m_DisplayLogLineStartPos++;
    }
}
void LogScene::DisplayRangeReset()
{
    int count = gLog.GetCount();
    m_DisplayLogLineStartPos = std::max(0, count - DisplayLogLineSize);

}

void LogScene::SetEnabledAutoScroll(bool isEnabledAutoFlow)
{
    m_IsEnabledAutoScroll = isEnabledAutoFlow;
}

void LogScene::Draw()
{
    int mStartX = m_DrawPosX;
    int mStartY = m_DrawPosY;
    const int textMarginH = 10;

    const nn::util::Color4u8Type bgColor = (m_IsEnabledAutoScroll) ? DefaultBgColor : ControllableBgColor;
    gDrawer.DrawRect(mStartX, mStartY, 1280 - mStartX * 2, 620, bgColor);

    int displayLogLineEndPos = std::min(m_DisplayLogLineStartPos + DisplayLogLineSize, gLog.GetCount());

    int i = 0;
    for (int num = m_DisplayLogLineStartPos; num < displayLogLineEndPos; num++)
    {
        int lineNum = num % gLog.MaxLogLineSize;
        nn::util::Color4u8Type color;
        switch (gLog.GetLevel(lineNum))
        {
        case Log::LogLevel::Debug:
            color = DebugLogColor;
            break;
        case Log::LogLevel::Warning:
            color = WarningLogColor;
            break;
        case Log::LogLevel::Error:
            color = ErrorLogColor;
            break;
        case Log::LogLevel::Info:
        default:
            color = InfoLogColor;
            break;
        }

        gWriter.SetTextColor(color);
        gWriter.SetCursor(mStartX, mStartY + LineOffset*i + textMarginH);
        gWriter.Print("%s",gLog.GetBuffer(lineNum));
        i++;
    }

    gWriter.SetTextColor(ControllableBgColor);
    gWriter.SetCursor(1280 - mStartX - 100, mStartY + LineOffset*(DisplayLogLineSize - 1) + textMarginH);
    gWriter.Print("Auto-Scroll");
}

void LogScene::Update()
{
    if (m_IsEnabledAutoScroll)
    {
        DisplayRangeReset();
    }
}

void LogScene::Control()
{
    if (gInput.isRep(nn::hid::NpadButton::Up::Mask))
    {
        SetEnabledAutoScroll(false);
        DisplayRangeUp();
    }
    if (gInput.isRep(nn::hid::NpadButton::Down::Mask))
    {
        SetEnabledAutoScroll(false);
        DisplayRangeDown();
    }
}

std::string LogScene::GetDescription()
{
    return "Desc : LogViewScene";
}

