﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <functional>

#include <nn/err.h>

#include "ShopMonitoringTool_SysFramework.h"
#include "ShopMonitoringTool_UiScene.h"
#include "ShopMonitoringTool_UiProcTimer.h"
#include "ShopMonitoringTool_UiExecuteItem.h"

class ExecutorScene : public Scene
{
public:
    enum class ProcessState
    {
        Standby,
        Processing,
        Waiting,
        Canceling,
        Result,
        Alert,
    };
    enum class ExecuteMode
    {
        Selective,
        Continuous,
    };
private:
    static const size_t ThreadStackSize = 512 * 1024;  // スレッドのスタックサイズ
public:
    ExecutorScene();
    virtual ~ExecutorScene();
    void SetupScene();
    void PushTask(ExecuteItem* _pTask);
    void SetEnableAutoRestart(bool enableAutoRestart);
    void SetEnablShowErrorApplet(bool enablShowErrorApplet);
    void SetErrorCountLimit(int errorCountLimit);
    void SetAutoRestartWaitTime(int autoRestartWaitTime);
    void SetAutoRetryWaitTime(int autoRetryWaitTime);
    void SetExecutionMode(ExecuteMode mode);
    virtual void Draw();
    void Update();
    void Control();
    std::string GetDescription();
    static void ProcessThreadMain(void *arg);
private:
    void ThrowError();
    void ResetErrorCount();
    void NextTask();
    void PrevTask();
    void ResetAllTaskState();
    void ClearTaskList();
    void ClearLastTaskState();
    void ExecuteContinuousTask(void *arg);
    void ExecuteSelectedTask(void *arg);
protected:
    static NN_OS_ALIGNAS_THREAD_STACK char m_ThreadStack[ThreadStackSize];  // スレッドのスタック
    std::vector<ExecuteItem*> m_TaskList;
    ProcessState m_ProcessState;
    ExecuteMode m_ExecuteMode;
    ExecuteItem::ExecuteState m_LastTaskState;
    std::string m_LastTaskName;
    std::string m_LastTaskErrorDescription;
    int         m_AutoRestartWaitTime;
    int         m_AutoRetryWaitTime;
    int         m_AutoContinueWaitTime;
    float       m_CurrentRemainingTime;
    int         m_ErrorCountLimit;
    int         m_CurrentErrorCount;
    uint64_t    m_LapCount;
    int m_SelectTaskNum;
private:
    nn::os::ThreadType  m_ProcessThread;
    nn::os::EventType   m_ProcessCancelEvent;
    nn::os::EventType   m_ProcessTerminateEvent;
    nn::os::EventType   m_ProcessCompleteEvent;
    nn::os::EventType   m_ProcessStartAsContinuousEvent;
    nn::os::EventType   m_ProcessStartAsSelectiveEvent;
    bool        m_IsEnablShowErrorApplet;
    bool        m_IsEnableAutoRestart;
    ProcTimer   m_Timer;

};
