﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/hid/hid_NpadSixAxisSensor.h>
#include <nn/hid/hid_SixAxisSensor.h>
#include <nn/hid/hid_Vibration.h>

#include "ShopMonitoringTool_SysFramework.h"

#ifndef gInput
#define gInput (Input::GetInstance())
#endif

class NpadButtonCounter
{
public:
    enum class CountMode
    {
        Max = 0,
        Min,
        MaxOmitRel
    };
public:
    static const uint32_t MaxNpadButtons = 64;
    NpadButtonCounter() { memset(m_Count, 0, sizeof(m_Count)); }
    const uint64_t GetCount(const nn::hid::NpadButtonSet& button, CountMode mode) const NN_NOEXCEPT;
    const uint64_t  GetCount(uint32_t index) const NN_NOEXCEPT;
    void Update(const nn::hid::NpadButtonSet& button) NN_NOEXCEPT;
private:
    uint64_t m_Count[MaxNpadButtons];
};

class Input
{
private:
    static const uint32_t RepeatStartTime = 40;
    static const uint32_t RepeatSpan = 5;
    static const uint32_t MaxNpadDeviceCount = 2;
public:
    static Input& GetInstance() NN_NOEXCEPT;
    void Initialize();
    void Finalize() NN_NOEXCEPT {}
    void Update() NN_NOEXCEPT;
    nn::hid::NpadButtonSet GetNpadButtonSet() const  NN_NOEXCEPT;
    bool isTrg(const nn::hid::NpadButtonSet& button) const NN_NOEXCEPT;
    bool isHld(const nn::hid::NpadButtonSet& button) const NN_NOEXCEPT;
    bool isRep(const nn::hid::NpadButtonSet& button) const NN_NOEXCEPT;
    bool isRel(const nn::hid::NpadButtonSet& button) const NN_NOEXCEPT;
private:
    NpadButtonCounter   m_ButtonPressCount;
    nn::hid::NpadIdType m_NpadIds[MaxNpadDeviceCount];
    uint64_t            m_NpadInputCount[MaxNpadDeviceCount];
    nn::hid::NpadButtonSet m_InputButtonSet;
    nn::hid::NpadButtonSet GetDebugPadButtons();
};
