﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_Color.h>

#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>

#ifndef gDrawer
#define gDrawer (Drawer::GetInstance())
#endif

class Drawer
{
public:
    static Drawer& GetInstance() NN_NOEXCEPT;
    void InitializeTextureResource(const char* filename) NN_NOEXCEPT;
    void FinalizeTextureResource() NN_NOEXCEPT;
    int GetTextureCount() NN_NOEXCEPT;
    void DrawRect(float x, float y, float w, float h,
        const nn::util::Color4u8Type& color = DefaultColor) NN_NOEXCEPT;

    void DrawLine(float beginX, float beginY, float endX, float endY,
        const nn::util::Color4u8Type& color = DefaultColor) NN_NOEXCEPT;

    void DrawFrame(float x, float y, float w, float h,
        const nn::util::Color4u8Type& color = DefaultColor) NN_NOEXCEPT;

    void DrawTexture(int indexSlot, float x, float y, float w, float h,
        const nn::util::Color4u8Type& color = DefaultColor) NN_NOEXCEPT;
private:
    static const nn::util::Color4u8Type DefaultColor;
private:
    void* ReadResource(const char* filename) NN_NOEXCEPT;
private:
    nn::util::BytePtr m_pMemoryHeap = nn::util::BytePtr(NULL);
    nn::util::BytePtr m_pMemory = nn::util::BytePtr(NULL);
    int m_TextureDescriptorBaseIndex;
    int m_SamplerDescriptorBaseIndex;
    nn::gfx::ResTextureFile* m_pResTextureFile;
};
