﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>
#include <cstring>
#include <vector>
#include <map>

#include <nn/mem/mem_StandardAllocator.h>
#include <nn/vi.h>
#include <nn/gfx.h>

#ifndef gGraphics
#define gGraphics (Graphics::GetInstance())
#endif

class Graphics
{
public:
    static const int DisplayWidth = 1280;
    static const int DisplayHeight = 720;
private:
    bool m_Initialized;
    int  m_BufferIndex;
public:
    nn::mem::StandardAllocator  m_PrimitiveRendererAllocator;
    void*                       m_pPrimitiveRendererAllocatorMemory;
private:
    Graphics();
    void InitializeGraphicsFramework() NN_NOEXCEPT;
    void InitializeDebugFont() NN_NOEXCEPT;
    void InitializePrimitiveRenderer() NN_NOEXCEPT;
    void InitializeUserShader() NN_NOEXCEPT;
    void FinalizePrimitiveRenderer() NN_NOEXCEPT;
    void FinalizeDebugFont() NN_NOEXCEPT;
    void FinalizeGraphicsFramework() NN_NOEXCEPT;
    void FinalizeUserShader() NN_NOEXCEPT;
public:
    ~Graphics();
    static Graphics& GetInstance() NN_NOEXCEPT;
    bool IsInitialized() const NN_NOEXCEPT;
    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    void ClearColor() NN_NOEXCEPT;
    void BeginDraw() NN_NOEXCEPT;
    void EndDraw() NN_NOEXCEPT;
    void* GetFramework() NN_NOEXCEPT;
    void* GetWriter() NN_NOEXCEPT;
    void* GetRenderer(void* setRenderer = nullptr) NN_NOEXCEPT;
    int GetBufferIndex() NN_NOEXCEPT;
};
