﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/result/result_HandlingUtility.h>
#include <nn/ec/system/ec_Async.h>

class ShopCommandManager
{
public:
    void SetUserIndex(int userIndex);
    void SetTimeOut(nn::util::optional<nn::TimeSpan> timeout);
    void SetDownloadTicketApplicationIdString(std::string downloadTicketApplicationIdString);
    void SetDownloadTicketKeyIdString(std::string downloadTicketKeyIdString);
    void SetDownloadDemoApplicationIdString(std::string downloadDemoApplicationIdString);
    void SetPurchaseNsUidString(std::string purchaseNsUidString);
    nn::Result WaitAsync(nn::ec::system::AsyncResult* async);
    template<typename T>
    nn::Result WaitAsync(T* outValue, nn::ec::system::AsyncValue<T>* async);
    nn::Result CheckUidFromIndex(bool* outValue, nn::util::optional<nn::account::Uid>* pUid, int userIndex);
    nn::Result RegisterDeviceAccount(bool* outValue);
    nn::Result UnregisterDeviceAccount(bool* outValue);
    nn::Result DeviceRegistrationInfo(bool* outValue);
    nn::Result DeviceAccountStatus(bool* outValue);
    nn::Result DeviceAccountInfo(bool* outValue);
    nn::Result DeviceAuthenticationToken(bool* outValue);
    nn::Result ShopAccountStatus(bool* outValue);
    nn::Result DeviceLinkStatus(bool* outValue);
    nn::Result HasDeviceLink(bool* outValue);
    nn::Result DeleteAllRights(bool* outValue);
    nn::Result DownloadTicket(bool* outValue);
    nn::Result Prepurchase(bool* outValue);
    nn::Result Purchase(bool* outValue);
    nn::Result DownloadDemo(bool* outValue);
    nn::Result LinkDevice(bool* outValue);
    nn::Result UnlinkDevice(bool* outValue);
    nn::Result UnlinkDeviceAll(bool* outValue);
    nn::Result SyncTicket(bool* outValue);
    nn::Result Search(bool* outValue);
    nn::Result Start(bool* outValue);
private:
    int m_UserIndex;
    std::string m_DownloadTicketApplicationIdString;
    std::string m_DownloadTicketKeyIdString;
    std::string m_DownloadDemoApplicationIdString;
    std::string m_PurchaseNsUidString;
    nn::util::optional<nn::TimeSpan> m_TimeOut;
};
