﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <sstream>
#include <vector>
#include <nn/nn_Common.h>

namespace qcit
{

// 文字列操作のユーティリティクラス
class StringUtil
{
public:
    static const char* ToString(bool inBool) NN_NOEXCEPT
    {
        return (inBool == true) ? "True" : "False";
    }

        template <typename T>
    static std::string ToString(T inVal) NN_NOEXCEPT
    {
        std::ostringstream os;
        os << inVal;
        return os.str();
    }

    static double ToDouble(const std::string& inStr) NN_NOEXCEPT
    {
        std::istringstream is(inStr);
        double num = 0.0;
        is >> num;
        return num;
    }

    static nn::Bit32 ToBit32(const std::string& inStr) NN_NOEXCEPT
    {
        std::istringstream is(inStr);
        nn::Bit32 num = 0x00000000;
        is >> num;
        return num;
    }

    static nn::Bit64 ToBit64(const std::string& inStr) NN_NOEXCEPT
    {
        std::istringstream is(inStr);
        nn::Bit64 num = 0;
        auto pos = inStr.find("0x");
        if (pos == std::string::npos)
        {
            is >> num;
        }
        else
        {
            is >> std::hex >> num;
        }
        return num;
    }
};

// 上限文字数(maxLength)を超えた文字列を短縮形に整形します
std::string ClipMessage(const std::string& inString, size_t maxLength) NN_NOEXCEPT;

// 入力"秒"を "* h, * min, * sec" の文字列フォーマットで出力します
std::string ConvertToFormatTime(int64_t inSecond) NN_NOEXCEPT;

// 改行を区切り文字としてリスト形式に変換する
void ConvertToLineDelimList(const std::string& inSrcData, std::vector<std::string>& outList) NN_NOEXCEPT;

}
