﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cmath>
#include "QCIT_StringUtil.h"

namespace qcit
{

std::string ClipMessage(const std::string& inString, size_t maxLength) NN_NOEXCEPT
{
    const auto stringLength = inString.length();

    // 文字数が多い場合は、最初と最後から数文字だけを表示
    if (stringLength > maxLength)
    {
        // " ... " と終端文字の長さを引く
        const size_t includeMessageLength = maxLength - 6;

        // 表示する文字を前半:後半 = 1:2 とする
        const size_t firstSize = includeMessageLength / 3;
        const size_t endSize = static_cast<size_t>(std::ceilf(static_cast<float>(includeMessageLength) * 2.0f / 3.0f));

        const std::string firstMessage = inString.substr(0, firstSize - 1);
        const std::string endMessage = inString.substr(stringLength - endSize);

        return firstMessage + std::string(" ... ") + endMessage;
    }

    return inString;
}

std::string ConvertToFormatTime(int64_t inSecond) NN_NOEXCEPT
{
    int64_t minute = inSecond / 60;
    if (minute == 0)
    {
        auto secStr = StringUtil::ToString(inSecond);
        return secStr + " sec";
    }

    int64_t hour = minute / 60;
    if (hour == 0)
    {
        auto secStr = StringUtil::ToString(inSecond % 60);
        auto minStr = StringUtil::ToString(minute);
        return minStr + " min " + secStr + " sec";
    }

    auto secStr = StringUtil::ToString(inSecond % 60);
    auto minStr = StringUtil::ToString(minute % 60);
    auto hourStr = StringUtil::ToString(hour);
    return hourStr + " h " + minStr + " min " + secStr + " sec";
}

void ConvertToLineDelimList(const std::string& inSrcStrData, std::vector<std::string>& outList) NN_NOEXCEPT
{
    std::stringstream ss(inSrcStrData);

    std::string lineStr;
    while (std::getline(ss, lineStr))
    {
        // \r が末尾に存在する場合を考慮して、\r が存在すれば消しておく
        if (*lineStr.rbegin() == '\r')
        {
            lineStr.erase(lineStr.size() - 1);
        }

        outList.push_back(lineStr);
    }
}

}
