﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace qcit
{

struct AppInfoData
{
    std::string applicationId;
    std::string version;
};

class ApplicationInfo
{
    NN_DISALLOW_COPY(ApplicationInfo);
    NN_DISALLOW_MOVE(ApplicationInfo);

public:
    ApplicationInfo() NN_NOEXCEPT;
    virtual ~ApplicationInfo() NN_NOEXCEPT;

    nn::Result ReadInfo(const std::string& inInfoFilePath) NN_NOEXCEPT;

    void GetData(AppInfoData& outData) NN_NOEXCEPT
    {
        outData = m_Data;
    }

private:
    AppInfoData m_Data;
};

}
