﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>
#include <glv.h>
#include <glv_binding.h>
#include <glv_resources.h>

struct ButtonSampleResult
{
    int all;
    int aPushed;
    int bPushed;
};


void PrintNpadButtonState(const nn::hid::NpadButtonSet& state);
void PrintNpadStickState(const nn::hid::AnalogStickState& state);
void PrintNpadStickState(const nn::hid::AnalogStickState& state);
void Init();
void WaitJoyInput(int index);
void WaitJoyRelase();
void Update(ButtonSampleResult& result);
void SampleJoyInputs(ButtonSampleResult& result);
void InspectJoyCon(glv::GLV& glvRootView);

