﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/* 多重インクルードの回避 */
#pragma once

#include <memory>
#include <nn/fan/fan.h>

namespace ptd {
    namespace lib {

        class Gpio;
        class CpuFan
        {
        public:
            CpuFan();
            ~CpuFan();

            /*!
            * @brief		CPU ファンの回転有無を調べます。
            * @return		回転していれば true、止まっていれば false を返します。
            */
            bool IsRotated() NN_NOEXCEPT;

            /*!
            * @brief		CPU ファンの回転速度レベルを設定します。
            * @param[in]	level		回転速度レベル
            * @pre			回転速度は 10 段階(0 から nn::fan::RotationSpeedLevelMax-1 まで)で指定できます。
            */
            void SetSpeed(int level) NN_NOEXCEPT;

            /*!
            * @brief		CPU ファンの回転速度レベルを PROVISIONAL_SYSTEM_SPEED に設定します。
            */
            void SetProvisionalSystemSpeed() NN_NOEXCEPT;

            /*!
            * @brief		CPU ファンの回転速度レベルを MAX_SPEED に設定します。
            */
            void SetMaxSpeed() NN_NOEXCEPT;

            /*!
            * @brief		CPU ファンの回転速度レベルを取得します。
            * @return		CPU ファンの回転速度を返します。
            */
            int GetSpeed() NN_NOEXCEPT;

            /*!
            * @brief		CPU ファンのRPMを取得します。
            * @return		CPU ファンのRPMを返します。無回転の場合は0を返します。
            */
            int GetRpm() NN_NOEXCEPT;

        protected:

        private:
            /*!
            * @brief		CPU ファンの回転速度レベルの端数処理をします。
            * @param[in]	*level		回転速度レベルのポインタ
            * @pre			下限を 0 上限を MAX_SPEED に丸めます。
            */
            void RoundingSpeedLevel(int* plevel) NN_NOEXCEPT;

            std::unique_ptr<Gpio> m_gpio;
            nn::fan::Controller m_ctrl;

            bool m_isFanControlEnabled;

            static const nn::fan::RotationSpeedLevel PROVISIONAL_SYSTEM_SPEED = 6;
            static const nn::fan::RotationSpeedLevel MAX_SPEED = nn::fan::RotationSpeedLevelMax; // 古い SDK ではアボートで止まるので注意！
        };

    }
}
