﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Assert.h>

#include "NoftWriter_Window.h"
#include "NoftWriter_Spinner.h"

namespace noftwriter { namespace ui {

/**
 * @brief   待機中であることを示すウィンドウです。
 */
class WaitDialog : public Window
{
public:
    WaitDialog() NN_NOEXCEPT :
        m_Spinner(),
        m_Text(nullptr)
    {
        m_Spinner.Show();
    }

    /**
     * @brief   表示する文字列を設定します。
     */
    void SetText(const char* text) NN_NOEXCEPT
    {
        m_Text = text;
    }

    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Render() NN_NOEXCEPT NN_OVERRIDE;

private:
    Spinner     m_Spinner;  //!< 待機アニメーション
    const char* m_Text;     //!< 表示する文字列
};

}}  // noftwriter::ui
