﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Assert.h>

#include "NoftWriter_Window.h"

namespace noftwriter { namespace ui {

/**
 * @brief   選択肢を表示するウィンドウの抽象クラスです。
 */
class SelectableWindow : public Window
{
public:
    /**
     * @brief   カーソル位置を設定します。
     */
    virtual void SetCursorIndex(int index) NN_NOEXCEPT = 0;

    /**
     * @brief   カーソル位置を取得します。
     */
    virtual int GetCursorIndex() const NN_NOEXCEPT = 0;

    /**
     * @brief   カーソル位置の項目の Y 座標を取得します。
     */
    virtual float GetSelectedItemY() const NN_NOEXCEPT = 0;
};

}}  // noftwriter::ui
