﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_Npad.h>
#include <nn/nfp/nfp_Types.h>

#include "graphics/NoftWriter_Renderer.h"

namespace noftwriter {

extern const float DisplayLineOffset;
extern const float DisplayColumnOffset;

/**
 * @brief   Npad ID の名前を取得
 */
const char* GetNpadIdName(const nn::hid::NpadIdType& npadId) NN_NOEXCEPT;

/**
 * @brief   Npad の操作形態の名前を取得
 */
const char* GetNpadStyleName(const nn::hid::NpadIdType& npadId) NN_NOEXCEPT;

/**
 * @brief   アプリケーションのヘッダを描画
 */
void PrintHeader(graphics::Renderer* pRenderer, const char* title) NN_NOEXCEPT;

/**
 * @brief   同一タグであるか判定
 */
bool IsSameTag(const nn::nfp::TagId& tagId1, const nn::nfp::TagId& tagId2) NN_NOEXCEPT;

/**
 * @brief   Result の文字列表現を取得
 */
const char* GetResultText(nn::Result result) NN_NOEXCEPT;

}  // noftwriter
