﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nfp/nfp_DebugTypes.h>

#include "../npad/NfpDebugTool_NpadController.h"
#include "../NfpDebugTool_NfpProcessor.h"
#include "NfpDebugTool_BaseTagInfoWindow.h"

namespace nfpdebug { namespace ui {

/**
 * @brief   amiibo タグの内容を表示するウィンドウです。
 */
class TagDumpWindow : public BaseTagInfoWindow
{
public:
    TagDumpWindow() NN_NOEXCEPT :
        m_AnimationDuration(0),
        m_DrawMode(DrawMode_Basic),
        m_NfpInfo()
    {
        SetSize(830, 560);
    }

    /**
     * @brief   ページを初期表示状態にします。
     */
    void InitializeDisplayPage() NN_NOEXCEPT
    {
        m_DrawMode = DrawMode_Basic;
    }

    /**
     * @brief   表示するタグの情報を設定します。
     */
    void SetNfpInfo(const NfpInfo& info) NN_NOEXCEPT
    {
        m_NfpInfo = info;
    }

    virtual void UpdateInput(const npad::INpadController& controller) NN_NOEXCEPT NN_OVERRIDE;
    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Render() NN_NOEXCEPT NN_OVERRIDE;

private:
    /**
     * @brief   描画モードの定義です。
     */
    enum DrawMode : int
    {
        DrawMode_Basic,             //!< 基本情報

#ifdef NFPDEBUG_SYSTEM
        DrawMode_System,            //!< システム情報
        DrawMode_Register,          //!< 登録情報
        DrawMode_Application,       //!< アプリケーション専用領域
        DrawMode_Max,

        DrawMode_SystemForGeneral,  //!< 一般公開用システム情報 (コード互換用)
#else
        DrawMode_SystemForGeneral,  //!< 一般公開用システム情報
        DrawMode_Application,       //!< アプリケーション専用領域
        DrawMode_Max,

        // 以下はコード互換用
        DrawMode_System,
        DrawMode_Register
#endif  // ifdef NFPDEBUG_SYSTEM
    };

private:
    void DrawPageCursor() NN_NOEXCEPT;
    void DrawPageIndicator() NN_NOEXCEPT;

    void DrawPageBasic(float x, float y) NN_NOEXCEPT;
    void DrawPageSystem(float x, float y) NN_NOEXCEPT;
    void DrawPageSystemForGeneral(float x, float y) NN_NOEXCEPT;
    void DrawPageRegister(float x, float y) NN_NOEXCEPT;
    void DrawPageApplication(float x, float y) NN_NOEXCEPT;

private:
    int         m_AnimationDuration;    //!< アニメーション時間
    DrawMode    m_DrawMode;             //!< 描画モード
    NfpInfo     m_NfpInfo;              //!< 表示する情報
};

}}  // nfpdebug::ui
