﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

#include "../NfpDebugTool_Types.h"
#include "../npad/NfpDebugTool_NpadController.h"
#include "NfpDebugTool_BaseTagInfoWindow.h"

namespace nfpdebug { namespace ui {

/**
 * @brief   cabinet の処理結果を表示するウィンドウです。
 */
class CabinetResultWindow : public BaseTagInfoWindow
{
public:
    CabinetResultWindow() NN_NOEXCEPT :
        m_CabinetResult()
    {
        SetSize(830, 560);
        m_CabinetResult.Initialize();
    }

    /**
     * @brief   表示する cabinet の処理結果を設定します。
     */
    void SetCabinetResult(const CabinetResult& result) NN_NOEXCEPT
    {
        m_CabinetResult = result;
    }

    virtual void UpdateInput(const npad::INpadController& controller) NN_NOEXCEPT NN_OVERRIDE;
    virtual void Render() NN_NOEXCEPT NN_OVERRIDE;

private:
    float DrawDeviceHandle(float x, float y, float offsetX, const nn::nfp::DeviceHandle& handle) NN_NOEXCEPT;

private:
    CabinetResult   m_CabinetResult;    //!< cabinet の処理結果
};

}}  // nfpdebug::ui
