﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nfp/nfp_DebugTypes.h>

#include "NfpDebugTool_Window.h"

namespace nfpdebug { namespace ui {

/**
 * @brief   amiibo タグの内容表示に関する機能を提供するウィンドウです。
 */
class BaseTagInfoWindow : public Window
{
protected:
    float DrawErrorText(float x, float y, const char* text) NN_NOEXCEPT;
    float DrawInfoTitle(float x, float y, const char* text) NN_NOEXCEPT;
    float DrawBinary(float x, float y, const char* pData, size_t dataBytes) NN_NOEXCEPT;
    float DrawBinaryFormatted(float x, float y, const char* pData, size_t dataBytes) NN_NOEXCEPT;

    float DrawTagInfo(float x, float y, float offsetX, const nn::nfp::TagInfo& tagInfo) NN_NOEXCEPT;
    float DrawModelInfo(float x, float y, float offsetX, const nn::nfp::ModelInfo& modelInfo) NN_NOEXCEPT;
    float DrawCommonInfo(float x, float y, float offsetX, const nn::nfp::CommonInfo& commonInfo) NN_NOEXCEPT;
    float DrawSystemInfo(float x, float y, float offsetX, const nn::nfp::SystemInfo& systemInfo) NN_NOEXCEPT;
    float DrawAdminInfo(float x, float y, float offsetX, const nn::nfp::AdminInfoDebug& adminInfo) NN_NOEXCEPT;
    float DrawRegisterInfo(float x, float y) NN_NOEXCEPT;
    float DrawRegisterInfo(
        float x,
        float y,
        float offsetX,
        const nn::nfp::RegisterInfo& registerInfo) NN_NOEXCEPT;
    float DrawRegisterInfo(
        float x,
        float y,
        float offsetX,
        const nn::nfp::RegisterInfoDebug& registerInfo) NN_NOEXCEPT;
    float DrawApplicationArea(float x, float y) NN_NOEXCEPT;
    float DrawApplicationArea(
        float x,
        float y,
        const char* pApplicationArea,
        size_t applicationAreaSize) NN_NOEXCEPT;
};

}}  // nfpdebug::ui
